/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.utils.network;

import com.hybridlab.utils.ByteUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

public class NetworkUtil {
    public static final UUID NULL_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static boolean validIP(String ip) {
        try {
            if (ip == null || ip.isEmpty()) {
                return false;
            }
            String[] parts = ip.split("\\.");
            if (parts.length != 4) {
                return false;
            }
            for (String s : parts) {
                int i = Integer.parseInt(s);
                if (i >= 0 && i <= 255) continue;
                return false;
            }
            return !ip.endsWith(".");
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static String getIdeationSpaceName(String fallbackName) {
        try {
            String hostname = NetworkUtil.getHostName();
            String ip = NetworkUtil.getIp();
            String json = NetworkUtil.getIpBasedLocationInfo(ip);
            JSONObject info = new JSONObject(json);
            String city = info.getString("city");
            String ipaddress = info.getString("ip");
            String countryName = info.getString("country_name");
            return String.format("%s (%s) in %s, %s", hostname, ipaddress, city, countryName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return fallbackName;
        }
    }

    public static String getHostName() throws Exception {
        String computername = InetAddress.getLocalHost().getHostName();
        return computername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIp() throws Exception {
        URL whatismyip = new URL("http://checkip.amazonaws.com");
        BufferedReader in = null;
        try {
            String ip;
            in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));
            String string = ip = in.readLine();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getIpBasedLocationInfo(String ip) throws Exception {
        try {
            String line;
            URL url = new URL("http://freegeoip.net/json/" + ip);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            InputStream is = connection.getInputStream();
            StringBuilder sb = new StringBuilder();
            int status = connection.getResponseCode();
            if (status != 200) {
                throw new Exception("Error " + String.valueOf(status));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static String getInterfaceInfos() {
        Object s = "";
        try {
            int i = 0;
            s = (String)s + "\n-(" + i++ + ")--InetAddress.getLocalHost()----------------";
            InetAddress h = InetAddress.getLocalHost();
            s = (String)s + "\n getHostName: " + h.getHostName() + "\n getHostAddress: " + h.getHostAddress() + "\n getCanonicalHostName: " + h.getCanonicalHostName();
            s = (String)s + "\n";
            Enumeration<NetworkInterface> nwinterfaces = NetworkInterface.getNetworkInterfaces();
            while (nwinterfaces.hasMoreElements()) {
                s = (String)s + "-(" + i++ + ")---------------\n";
                NetworkInterface e = nwinterfaces.nextElement();
                s = (String)s + "NetworkInterface getDisplayName: " + e.getDisplayName();
                List<InterfaceAddress> aa = e.getInterfaceAddresses();
                for (InterfaceAddress ifa : aa) {
                    if (!(ifa.getAddress().isSiteLocalAddress() || ifa.getAddress().isLoopbackAddress() || ifa.getAddress().isLinkLocalAddress() || ifa.getAddress().getHostAddress().indexOf(":") != -1)) {
                        s = (String)s + "\n getHostName: " + ifa.getAddress().getHostName() + "\n getHostAddress: " + ifa.getAddress().getHostAddress() + "\n getCanonicalHostName: " + ifa.getAddress().getCanonicalHostName() + "\n";
                        continue;
                    }
                    s = (String)s + "\n no usable addresses for this interface\n";
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String getMACAddressStringUpperCaseHexWithoutDelimiter() {
        return NetworkUtil.getMACAddressStringUpperCaseHex("");
    }

    public static void main(String[] args) {
        NetworkUtil.enumerateTest();
    }

    public static void enumerateTest() {
        PrintStream o = System.out;
        try {
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            while (ifs.hasMoreElements()) {
                NetworkInterface i = ifs.nextElement();
                o.println();
                o.println(i.getName());
                o.println(i.getDisplayName());
                for (InterfaceAddress a : i.getInterfaceAddresses()) {
                    o.println("--InterfaceAddress:");
                    InetAddress addr = a.getAddress();
                    o.println(addr.getCanonicalHostName());
                    o.println(addr.getHostAddress());
                    o.println(addr.getHostName());
                    o.println(ByteUtils.bytesToHex(addr.getAddress()));
                    o.println("###");
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public static String getMACAddressStringUpperCaseHex(String hexdelimiter) {
        String addr = "";
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? hexdelimiter : ""));
            }
            addr = sb.toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return addr;
    }
}

