/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.parser;

import com.momchil_atanasov.data.front.common.IFastFloat;
import com.momchil_atanasov.data.front.common.MTLLimits;
import com.momchil_atanasov.data.front.error.WFCorruptException;
import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.parser.MTLLibrary;
import com.momchil_atanasov.data.front.parser.MTLMaterial;
import com.momchil_atanasov.data.front.scanner.IMTLScannerHandler;
import com.momchil_atanasov.data.front.scanner.MTLLimitingScannerHandler;
import com.momchil_atanasov.data.front.scanner.MTLScanner;
import java.io.BufferedReader;
import java.io.IOException;

class MTLParseRunner
implements IMTLScannerHandler {
    private MTLLibrary library;
    private MTLMaterial currentMaterial;

    public MTLLibrary run(BufferedReader reader, MTLLimits limits) throws WFException, IOException {
        this.currentMaterial = null;
        this.library = new MTLLibrary();
        MTLScanner scanner = new MTLScanner();
        if (limits == null) {
            scanner.scan(reader, (IMTLScannerHandler)this);
        } else {
            scanner.scan(reader, (IMTLScannerHandler)new MTLLimitingScannerHandler(this, limits));
        }
        return this.library;
    }

    @Override
    public void onComment(String comment) throws WFException {
    }

    @Override
    public void onMaterial(String name) throws WFException {
        this.currentMaterial = new MTLMaterial(name);
        this.library.getMaterials().add(this.currentMaterial);
    }

    @Override
    public void onAmbientColorRGB(IFastFloat r, IFastFloat g, IFastFloat b) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.getAmbientColor().r = r.get();
        this.currentMaterial.getAmbientColor().g = g.get();
        this.currentMaterial.getAmbientColor().b = b.get();
    }

    @Override
    public void onDiffuseColorRGB(IFastFloat r, IFastFloat g, IFastFloat b) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.getDiffuseColor().r = r.get();
        this.currentMaterial.getDiffuseColor().g = g.get();
        this.currentMaterial.getDiffuseColor().b = b.get();
    }

    @Override
    public void onSpecularColorRGB(IFastFloat r, IFastFloat g, IFastFloat b) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.getSpecularColor().r = r.get();
        this.currentMaterial.getSpecularColor().g = g.get();
        this.currentMaterial.getSpecularColor().b = b.get();
    }

    @Override
    public void onTransmissionColorRGB(IFastFloat r, IFastFloat g, IFastFloat b) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.getTransmissionColor().r = r.get();
        this.currentMaterial.getTransmissionColor().g = g.get();
        this.currentMaterial.getTransmissionColor().b = b.get();
    }

    @Override
    public void onDissolve(IFastFloat amount) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.setDissolve(amount.get());
    }

    @Override
    public void onSpecularExponent(IFastFloat amount) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.setSpecularExponent(amount.get());
    }

    @Override
    public void onAmbientTexture(String filename) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.setAmbientTexture(filename);
    }

    @Override
    public void onDiffuseTexture(String filename) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.setDiffuseTexture(filename);
    }

    @Override
    public void onSpecularTexture(String filename) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.setSpecularTexture(filename);
    }

    @Override
    public void onSpecularExponentTexture(String filename) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.setSpecularExponentTexture(filename);
    }

    @Override
    public void onDissolveTexture(String filename) throws WFException {
        this.assertCurrentMaterial();
        this.currentMaterial.setDissolveTexture(filename);
    }

    private void assertCurrentMaterial() throws WFCorruptException {
        if (this.currentMaterial == null) {
            throw new WFCorruptException("Material name has not been defined.");
        }
    }
}

