/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.scanner;

import com.momchil_atanasov.data.front.common.IFastFloat;
import com.momchil_atanasov.data.front.common.MTLLimits;
import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.error.WFSizeException;
import com.momchil_atanasov.data.front.scanner.IMTLScannerHandler;

public class MTLLimitingScannerHandler
implements IMTLScannerHandler {
    private final IMTLScannerHandler delegate;
    private final MTLLimits limits;
    private int commentCount = 0;
    private int materialCount = 0;

    public MTLLimitingScannerHandler(IMTLScannerHandler delegate, MTLLimits limits) {
        this.delegate = delegate;
        this.limits = limits;
    }

    @Override
    public void onComment(String comment) throws WFException {
        ++this.commentCount;
        if (this.commentCount > this.limits.maxCommentCount) {
            throw new WFSizeException("Too many comments.");
        }
        this.delegate.onComment(comment);
    }

    @Override
    public void onMaterial(String name) throws WFException {
        ++this.materialCount;
        if (this.materialCount > this.limits.maxMaterialCount) {
            throw new WFSizeException("Too many materials.");
        }
        this.delegate.onMaterial(name);
    }

    @Override
    public void onAmbientColorRGB(IFastFloat r, IFastFloat g, IFastFloat b) throws WFException {
        this.delegate.onAmbientColorRGB(r, g, b);
    }

    @Override
    public void onDiffuseColorRGB(IFastFloat r, IFastFloat g, IFastFloat b) throws WFException {
        this.delegate.onDiffuseColorRGB(r, g, b);
    }

    @Override
    public void onSpecularColorRGB(IFastFloat r, IFastFloat g, IFastFloat b) throws WFException {
        this.delegate.onSpecularColorRGB(r, g, b);
    }

    @Override
    public void onTransmissionColorRGB(IFastFloat r, IFastFloat g, IFastFloat b) throws WFException {
        this.delegate.onTransmissionColorRGB(r, g, b);
    }

    @Override
    public void onDissolve(IFastFloat amount) throws WFException {
        this.delegate.onDissolve(amount);
    }

    @Override
    public void onSpecularExponent(IFastFloat amount) throws WFException {
        this.delegate.onSpecularExponent(amount);
    }

    @Override
    public void onAmbientTexture(String filename) throws WFException {
        this.delegate.onAmbientTexture(filename);
    }

    @Override
    public void onDiffuseTexture(String filename) throws WFException {
        this.delegate.onDiffuseTexture(filename);
    }

    @Override
    public void onSpecularTexture(String filename) throws WFException {
        this.delegate.onSpecularTexture(filename);
    }

    @Override
    public void onSpecularExponentTexture(String filename) throws WFException {
        this.delegate.onSpecularExponentTexture(filename);
    }

    @Override
    public void onDissolveTexture(String filename) throws WFException {
        this.delegate.onDissolveTexture(filename);
    }
}

