/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.scanner;

import com.momchil_atanasov.data.front.common.IFastFloat;
import com.momchil_atanasov.data.front.error.WFCorruptException;
import com.momchil_atanasov.data.front.scanner.WFScanCommand;

class MTLScanColor {
    private static final String SPECTRAL_COLOR = "spectral";
    private static final String XYZ_COLOR = "xyz";
    private IFastFloat r;
    private IFastFloat g;
    private IFastFloat b;

    public void process(WFScanCommand command) throws WFCorruptException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Insufficient color data.");
        }
        if (SPECTRAL_COLOR.equals(command.getStringParam(0))) {
            return;
        }
        if (XYZ_COLOR.equals(command.getStringParam(0))) {
            return;
        }
        this.r = command.getFastFloat(0);
        if (command.getParameterCount() < 3) {
            this.g = command.getFastFloat(0);
            this.b = command.getFastFloat(0);
        } else {
            this.g = command.getFastFloat(1);
            this.b = command.getFastFloat(2);
        }
    }

    public boolean isRGB() {
        return this.r != null && this.g != null && this.b != null;
    }

    public IFastFloat getR() {
        return this.r;
    }

    public IFastFloat getG() {
        return this.g;
    }

    public IFastFloat getB() {
        return this.b;
    }
}

