/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.scanner;

import com.momchil_atanasov.data.front.common.IFastFloat;
import com.momchil_atanasov.data.front.error.WFCorruptException;
import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.scanner.IMTLScannerHandler;
import com.momchil_atanasov.data.front.scanner.MTLScanColor;
import com.momchil_atanasov.data.front.scanner.WFScanCommand;
import java.io.BufferedReader;
import java.io.IOException;

class MTLScanRunner {
    private static final String COMMAND_MATERIAL = "newmtl";
    private static final String COMMAND_AMBIENT_COLOR = "Ka";
    private static final String COMMAND_DIFFUSE_COLOR = "Kd";
    private static final String COMMAND_SPECULAR_COLOR = "Ks";
    private static final String COMMAND_TRANSMISSION_COLOR = "Tf";
    private static final String COMMAND_DISSOLVE = "d";
    private static final String COMMAND_SPECULAR_EXPONENT = "Ns";
    private static final String COMMAND_AMBIENT_TEXTURE = "map_Ka";
    private static final String COMMAND_DIFFUSE_TEXTURE = "map_Kd";
    private static final String COMMAND_SPECULAR_TEXTURE = "map_Ks";
    private static final String COMMAND_SPECULAR_EXPONENT_TEXTURE = "map_Ns";
    private static final String COMMAND_DISSOLVE_TEXTURE = "map_d";
    private final IMTLScannerHandler handler;
    private final WFScanCommand command = new WFScanCommand();
    private final MTLScanColor color = new MTLScanColor();

    public MTLScanRunner(IMTLScannerHandler handler) {
        this.handler = handler;
    }

    public void run(BufferedReader reader) throws WFException, IOException {
        while (this.command.parse(reader)) {
            if (this.command.isEmpty()) continue;
            if (this.command.isComment()) {
                this.processComment(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_MATERIAL)) {
                this.processMaterial(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_AMBIENT_COLOR)) {
                this.processAmbientColor(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_DIFFUSE_COLOR)) {
                this.processDiffuseColor(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_SPECULAR_COLOR)) {
                this.processSpecularColor(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_TRANSMISSION_COLOR)) {
                this.processTransmissionColor(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_DISSOLVE)) {
                this.processDissolve(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_SPECULAR_EXPONENT)) {
                this.processSpecularExponent(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_AMBIENT_TEXTURE)) {
                this.processAmbientTexture(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_DIFFUSE_TEXTURE)) {
                this.processDiffuseTexture(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_SPECULAR_TEXTURE)) {
                this.processSpecularTexture(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_SPECULAR_EXPONENT_TEXTURE)) {
                this.processSpecularExponentTexture(this.command);
                continue;
            }
            if (!this.command.isCommand(COMMAND_DISSOLVE_TEXTURE)) continue;
            this.processDissolveTexture(this.command);
        }
    }

    private void processComment(WFScanCommand command) throws WFException {
        this.handler.onComment(command.getComment());
    }

    private void processMaterial(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing material name.");
        }
        this.handler.onMaterial(command.getStringParam(0));
    }

    private void processAmbientColor(WFScanCommand command) throws WFException {
        this.color.process(command);
        if (this.color.isRGB()) {
            this.handler.onAmbientColorRGB(this.color.getR(), this.color.getG(), this.color.getB());
        }
    }

    private void processDiffuseColor(WFScanCommand command) throws WFException {
        this.color.process(command);
        if (this.color.isRGB()) {
            this.handler.onDiffuseColorRGB(this.color.getR(), this.color.getG(), this.color.getB());
        }
    }

    private void processSpecularColor(WFScanCommand command) throws WFException {
        this.color.process(command);
        if (this.color.isRGB()) {
            this.handler.onSpecularColorRGB(this.color.getR(), this.color.getG(), this.color.getB());
        }
    }

    private void processTransmissionColor(WFScanCommand command) throws WFException {
        this.color.process(command);
        if (this.color.isRGB()) {
            this.handler.onTransmissionColorRGB(this.color.getR(), this.color.getG(), this.color.getB());
        }
    }

    private void processDissolve(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing dissolve factor.");
        }
        IFastFloat factor = command.getFastFloat(command.getLastParamIndex());
        this.handler.onDissolve(factor);
    }

    private void processSpecularExponent(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing specular exponent amount.");
        }
        IFastFloat amount = command.getFastFloat(command.getLastParamIndex());
        this.handler.onSpecularExponent(amount);
    }

    private void processAmbientTexture(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing ambient texture filename.");
        }
        String filename = this.getTextureFilename(command);
        this.handler.onAmbientTexture(filename);
    }

    private void processDiffuseTexture(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing diffuse texture filename.");
        }
        String filename = this.getTextureFilename(command);
        this.handler.onDiffuseTexture(filename);
    }

    private void processSpecularTexture(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing specular texture filename.");
        }
        String filename = this.getTextureFilename(command);
        this.handler.onSpecularTexture(filename);
    }

    private void processSpecularExponentTexture(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing specular exponent texture filename.");
        }
        String filename = this.getTextureFilename(command);
        this.handler.onSpecularExponentTexture(filename);
    }

    private void processDissolveTexture(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing dissolve texture filename.");
        }
        String filename = this.getTextureFilename(command);
        this.handler.onDissolveTexture(filename);
    }

    private String getTextureFilename(WFScanCommand command) {
        return command.getStringParam(command.getLastParamIndex());
    }
}

