/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.scanner;

import com.momchil_atanasov.data.front.common.IFastFloat;
import com.momchil_atanasov.data.front.common.IFastInt;
import com.momchil_atanasov.data.front.error.WFCorruptException;
import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.scanner.IOBJScannerHandler;
import com.momchil_atanasov.data.front.scanner.OBJScanDataReference;
import com.momchil_atanasov.data.front.scanner.WFScanCommand;
import java.io.BufferedReader;
import java.io.IOException;

class OBJScanRunner {
    private static final String COMMAND_VERTEX = "v";
    private static final String COMMAND_TEXCOORD = "vt";
    private static final String COMMAND_NORMAL = "vn";
    private static final String COMMAND_OBJECT = "o";
    private static final String COMMAND_FACE = "f";
    private static final String COMMAND_MATERIAL_REF = "usemtl";
    private static final String COMMAND_MATERIAL_LIB = "mtllib";
    private final IOBJScannerHandler handler;
    private final WFScanCommand command = new WFScanCommand();
    private final OBJScanDataReference dataReference = new OBJScanDataReference();

    public OBJScanRunner(IOBJScannerHandler handler) {
        this.handler = handler;
    }

    public void run(BufferedReader reader) throws WFException, IOException {
        while (this.command.parse(reader)) {
            if (this.command.isEmpty()) continue;
            if (this.command.isComment()) {
                this.processComment(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_VERTEX)) {
                this.processVertex(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_TEXCOORD)) {
                this.processTexCoord(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_NORMAL)) {
                this.processNormal(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_OBJECT)) {
                this.processObject(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_FACE)) {
                this.processFace(this.command);
                continue;
            }
            if (this.command.isCommand(COMMAND_MATERIAL_LIB)) {
                this.processMaterialLibrary(this.command);
                continue;
            }
            if (!this.command.isCommand(COMMAND_MATERIAL_REF)) continue;
            this.processMaterialReference(this.command);
        }
    }

    private void processComment(WFScanCommand command) throws WFException {
        this.handler.onComment(command.getComment());
    }

    private void processVertex(WFScanCommand command) throws WFException {
        if (command.getParameterCount() < 3) {
            throw new WFCorruptException("Insufficient vertex data.");
        }
        IFastFloat x = command.getFastFloat(0);
        IFastFloat y = command.getFastFloat(1);
        IFastFloat z = command.getFastFloat(2);
        IFastFloat w = command.getFastFloat(3);
        this.handler.onVertex(x, y, z, w);
    }

    private void processTexCoord(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Insufficient texture coordinate data.");
        }
        IFastFloat u = command.getFastFloat(0);
        IFastFloat v = command.getFastFloat(1);
        IFastFloat w = command.getFastFloat(2);
        this.handler.onTextureCoordinate(u, v, w);
    }

    private void processNormal(WFScanCommand command) throws WFException {
        if (command.getParameterCount() < 3) {
            throw new WFCorruptException("Insufficient normal data.");
        }
        IFastFloat x = command.getFastFloat(0);
        IFastFloat y = command.getFastFloat(1);
        IFastFloat z = command.getFastFloat(2);
        this.handler.onNormal(x, y, z);
    }

    private void processObject(WFScanCommand command) throws WFException {
        if (command.getParameterCount() == 0) {
            throw new WFCorruptException("Missing object name.");
        }
        String name = command.getStringParam(0).trim();
        this.handler.onObject(name);
    }

    private void processFace(WFScanCommand command) throws WFException {
        this.handler.onFaceBegin();
        for (int i = 0; i < command.getParameterCount(); ++i) {
            this.dataReference.parse(command.getStringParam(i));
            IFastInt vertexIndex = this.dataReference.getVertexIndex();
            IFastInt texCoordIndex = this.dataReference.getTexCoordIndex();
            IFastInt normalIndex = this.dataReference.getNormalIndex();
            this.handler.onDataReference(vertexIndex, texCoordIndex, normalIndex);
        }
        this.handler.onFaceEnd();
    }

    private void processMaterialLibrary(WFScanCommand command) throws WFException {
        for (int i = 0; i < command.getParameterCount(); ++i) {
            String materialLibraryPath = command.getStringParam(i);
            this.handler.onMaterialLibrary(materialLibraryPath);
        }
    }

    private void processMaterialReference(WFScanCommand command) throws WFException {
        if (command.getParameterCount() > 0) {
            String name = command.getStringParam(0).trim();
            this.handler.onMaterialReference(name);
        } else {
            this.handler.onMaterialReference(null);
        }
    }
}

