/*
 * Decompiled with CFR 0.152.
 */
package com.momchil_atanasov.data.front.scanner;

import com.momchil_atanasov.data.front.common.FastFloat;
import com.momchil_atanasov.data.front.common.IFastFloat;
import com.momchil_atanasov.data.front.error.WFCorruptException;
import java.io.BufferedReader;
import java.io.IOException;

class WFScanCommand {
    private static final int FAST_FLOAT_POOL_SIZE = 4;
    private static final String WHITE_SPACE_PATTERN = "[\\s]+";
    private static final String COMMENT_SEPARATOR = "#";
    private static final int COMMENT_SEPARATOR_LENGTH = "#".length();
    private static final String LINE_EXTENSION = "\\";
    private final FastFloat[] fastFloats = new FastFloat[4];
    private final StringBuilder logicalLineBuilder = new StringBuilder();
    private String logicalLine;
    private String[] segments;

    public WFScanCommand() {
        for (int i = 0; i < 4; ++i) {
            this.fastFloats[i] = new FastFloat();
        }
    }

    public boolean parse(BufferedReader reader) throws IOException {
        String line = this.readLogicalLine(reader);
        if (line == null) {
            return false;
        }
        this.logicalLine = line.trim();
        this.segments = this.logicalLine.split(WHITE_SPACE_PATTERN);
        return true;
    }

    public boolean isEmpty() {
        return this.segments[0].isEmpty();
    }

    public boolean isComment() {
        return this.segments[0].startsWith(COMMENT_SEPARATOR);
    }

    public String getComment() {
        int commentIndex = this.logicalLine.indexOf(COMMENT_SEPARATOR);
        String commentSegment = this.logicalLine.substring(commentIndex + COMMENT_SEPARATOR_LENGTH);
        return commentSegment.trim();
    }

    public boolean isCommand(String commandName) {
        return commandName.equals(this.segments[0]);
    }

    public int getParameterCount() {
        return Math.max(0, this.segments.length - 1);
    }

    public int getLastParamIndex() {
        return this.getParameterCount() - 1;
    }

    public String getStringParam(int index) {
        return this.segments[index + 1];
    }

    public float getFloatParam(int index) throws WFCorruptException {
        try {
            return Float.parseFloat(this.getStringParam(index));
        }
        catch (NumberFormatException ex) {
            throw new WFCorruptException("Could not parse float value.");
        }
    }

    public IFastFloat getFastFloat(int index) throws WFCorruptException {
        int segmentIndex = index + 1;
        if (segmentIndex >= this.segments.length) {
            return null;
        }
        FastFloat fastFloat = this.fastFloats[index];
        fastFloat.set(this.getFloatParam(index));
        return fastFloat;
    }

    private String readLogicalLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        if (!line.endsWith(LINE_EXTENSION)) {
            return line;
        }
        this.logicalLineBuilder.setLength(0);
        while (line != null && line.endsWith(LINE_EXTENSION)) {
            String lineContent = line.substring(0, line.length() - 1);
            this.logicalLineBuilder.append(lineContent);
            line = reader.readLine();
        }
        if (line != null) {
            this.logicalLineBuilder.append(line);
        }
        return this.logicalLineBuilder.toString();
    }
}

