/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Context;
import com.jme3.opencl.Device;
import com.jme3.opencl.Image;
import com.jme3.opencl.MemoryAccess;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.Program;
import com.jme3.opencl.lwjgl.LwjglBuffer;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglImage;
import com.jme3.opencl.lwjgl.LwjglProgram;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CL12GL;
import org.lwjgl.opencl.CLImageDesc;
import org.lwjgl.opencl.CLImageFormat;

public class LwjglContext
extends Context {
    private static final Logger LOG = Logger.getLogger(LwjglContext.class.getName());
    private final long context;
    private final List<LwjglDevice> devices;

    public LwjglContext(long context, List<LwjglDevice> devices) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(context, devices));
        this.context = context;
        this.devices = devices;
    }

    public long getContext() {
        return this.context;
    }

    public List<LwjglDevice> getDevices() {
        return this.devices;
    }

    public CommandQueue createQueue(Device device) {
        assert (this.devices.contains(device));
        long d = ((LwjglDevice)device).getDevice();
        long properties = 0L;
        long q = CL10.clCreateCommandQueue((long)this.context, (long)d, (long)properties, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateCommandQueue");
        return new LwjglCommandQueue(q, device);
    }

    public Buffer createBuffer(long size, MemoryAccess access) {
        long flags = Utils.getMemoryAccessFlags(access);
        long mem = CL10.clCreateBuffer((long)this.context, (long)flags, (long)size, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateBuffer");
        return new LwjglBuffer(mem);
    }

    public Buffer createBufferFromHost(ByteBuffer data, MemoryAccess access) {
        long flags = Utils.getMemoryAccessFlags(access);
        long mem = CL10.clCreateBuffer((long)this.context, (long)(flags |= 8L), (ByteBuffer)data, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateBuffer");
        return new LwjglBuffer(mem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createImage(MemoryAccess access, Image.ImageFormat format, Image.ImageDescriptor descr) {
        long memFlags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        CLImageFormat f = null;
        CLImageDesc d = null;
        try {
            f = CLImageFormat.malloc();
            d = CLImageDesc.calloc();
            f.image_channel_data_type(LwjglImage.decodeImageChannelType(format.channelType));
            f.image_channel_order(LwjglImage.decodeImageChannelOrder(format.channelOrder));
            d.image_type(LwjglImage.decodeImageType(descr.type));
            d.image_width(descr.width);
            d.image_height(descr.height);
            d.image_depth(descr.depth);
            d.image_array_size(descr.arraySize);
            d.image_row_pitch(descr.rowPitch);
            d.image_slice_pitch(descr.slicePitch);
            long mem = CL12.clCreateImage((long)this.context, (long)memFlags, (CLImageFormat)f, (CLImageDesc)d, (ByteBuffer)descr.hostPtr, (IntBuffer)Utils.errorBuffer);
            Utils.checkError(Utils.errorBuffer, "clCreateImage");
            LwjglImage lwjglImage = new LwjglImage(mem);
            return lwjglImage;
        }
        finally {
            if (f != null) {
                f.free();
            }
            if (d != null) {
                d.free();
            }
        }
    }

    public Image.ImageFormat[] querySupportedFormats(MemoryAccess access, Image.ImageType type) {
        long memFlags = Utils.getMemoryAccessFlags(access);
        int typeFlag = LwjglImage.decodeImageType(type);
        Utils.tempBuffers[0].b16i.rewind();
        int ret = CL10.clGetSupportedImageFormats((long)this.context, (long)memFlags, (int)typeFlag, null, (IntBuffer)Utils.tempBuffers[0].b16i);
        Utils.checkError(ret, "clGetSupportedImageFormats");
        int count = Utils.tempBuffers[0].b16i.get(0);
        if (count == 0) {
            return new Image.ImageFormat[0];
        }
        CLImageFormat.Buffer formatsB = new CLImageFormat.Buffer(BufferUtils.createByteBuffer((int)(count * CLImageFormat.SIZEOF)));
        ret = CL10.clGetSupportedImageFormats((long)this.context, (long)memFlags, (int)typeFlag, (CLImageFormat.Buffer)formatsB, (IntBuffer)null);
        Utils.checkError(ret, "clGetSupportedImageFormats");
        Image.ImageFormat[] formats = new Image.ImageFormat[count];
        for (int i = 0; i < count; ++i) {
            CLImageFormat f = (CLImageFormat)formatsB.get();
            Image.ImageChannelOrder channelOrder = LwjglImage.encodeImageChannelOrder(f.image_channel_order());
            Image.ImageChannelType channelType = LwjglImage.encodeImageChannelType(f.image_channel_data_type());
            formats[i] = new Image.ImageFormat(channelOrder, channelType);
        }
        return formats;
    }

    public Buffer bindVertexBuffer(VertexBuffer vb, MemoryAccess access) {
        Utils.assertSharingPossible();
        int id = vb.getId();
        if (id == -1) {
            throw new IllegalArgumentException("vertex buffer was not yet uploaded to the GPU or is CPU only");
        }
        long flags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        long mem = CL10GL.clCreateFromGLBuffer((long)this.context, (long)flags, (int)id, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLBuffer");
        return new LwjglBuffer(mem);
    }

    public Image bindImage(com.jme3.texture.Image image, Texture.Type textureType, int mipLevel, MemoryAccess access) {
        Utils.assertSharingPossible();
        int imageID = image.getId();
        if (imageID == -1) {
            throw new IllegalArgumentException("image was not yet uploaded to the GPU");
        }
        long memFlags = Utils.getMemoryAccessFlags(access);
        int textureTarget = this.convertTextureType(textureType);
        Utils.errorBuffer.rewind();
        long mem = CL12GL.clCreateFromGLTexture((long)this.context, (long)memFlags, (int)textureTarget, (int)mipLevel, (int)imageID, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLTexture");
        return new LwjglImage(mem);
    }

    protected Image bindPureRenderBuffer(FrameBuffer.RenderBuffer buffer, MemoryAccess access) {
        Utils.assertSharingPossible();
        int renderbuffer = buffer.getId();
        if (renderbuffer == -1) {
            throw new IllegalArgumentException("renderbuffer was not yet uploaded to the GPU");
        }
        long memFlags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        long mem = CL10GL.clCreateFromGLRenderbuffer((long)this.context, (long)memFlags, (int)renderbuffer, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLRenderbuffer");
        return new LwjglImage(mem);
    }

    private int convertTextureType(Texture.Type textureType) {
        switch (textureType) {
            case TwoDimensional: {
                return 3553;
            }
            case TwoDimensionalArray: {
                return 35866;
            }
            case ThreeDimensional: {
                return 32879;
            }
            case CubeMap: {
                return 34067;
            }
        }
        throw new IllegalArgumentException("unknown texture type " + textureType);
    }

    public Program createProgramFromSourceCode(String sourceCode) {
        LOG.log(Level.FINE, "Create program from source:\n{0}", sourceCode);
        Utils.errorBuffer.rewind();
        long p = CL10.clCreateProgramWithSource((long)this.context, (CharSequence)sourceCode, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateProgramWithSource");
        return new LwjglProgram(p, this);
    }

    public Program createProgramFromBinary(ByteBuffer binaries, Device device) {
        Utils.errorBuffer.rewind();
        Utils.tempBuffers[0].b16i.rewind();
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[0].put(0, ((LwjglDevice)device).getDevice());
        long p = CL10.clCreateProgramWithBinary((long)this.context, (PointerBuffer)Utils.pointerBuffers[0], (ByteBuffer)binaries, (IntBuffer)Utils.tempBuffers[0].b16i, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateProgramWithBinary");
        Utils.checkError(Utils.tempBuffers[0].b16i, "clCreateProgramWithBinary");
        return new LwjglProgram(p, this);
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long context;
        private final List<LwjglDevice> devices;

        private ReleaserImpl(long mem, List<LwjglDevice> devices) {
            this.context = mem;
            this.devices = devices;
        }

        public void release() {
            if (this.context != 0L) {
                int ret = CL10.clReleaseContext((long)this.context);
                this.context = 0L;
                this.devices.clear();
                Utils.reportError(ret, "clReleaseMemObject");
            }
        }
    }
}

