/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugin.export.materialdef;

import com.jme3.material.MatParam;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNode;
import com.jme3.shader.ShaderNodeVariable;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VariableMapping;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class J3mdTechniqueDefWriter {
    public void write(TechniqueDef techniqueDef, Collection<MatParam> matParams, Writer out) throws IOException {
        out.write("    Technique");
        if (!techniqueDef.getName().equals("Default")) {
            out.write(" ");
            out.write(techniqueDef.getName());
        }
        out.write(" {\n");
        if (techniqueDef.getLightMode() != TechniqueDef.LightMode.Disable) {
            out.write("        LightMode ");
            out.write(techniqueDef.getLightMode().name());
            out.write("\n\n");
        }
        if (techniqueDef.getShadowMode() != TechniqueDef.ShadowMode.Disable) {
            out.write("        ShadowMode ");
            out.write(techniqueDef.getShadowMode().name());
            out.write("\n\n");
        }
        if (!techniqueDef.isUsingShaderNodes()) {
            this.writeShaders(techniqueDef, out);
        }
        if (!techniqueDef.getWorldBindings().isEmpty()) {
            this.writeWorldParams(techniqueDef, out);
        }
        if (techniqueDef.isUsingShaderNodes()) {
            this.writeShaderNodes(techniqueDef, matParams, out);
        } else if (techniqueDef.getDefineNames().length != 0) {
            this.writeDefines(techniqueDef, matParams, out);
        }
        RenderState rs = techniqueDef.getRenderState();
        if (rs != null) {
            out.write("        RenderState {\n");
            this.writeRenderState(rs, out);
            out.write("        }\n\n");
        }
        if ((rs = techniqueDef.getForcedRenderState()) != null) {
            out.write("        ForcedRenderState {\n");
            this.writeRenderState(rs, out);
            out.write("        }\n\n");
        }
        if (techniqueDef.isNoRender()) {
            out.write("        NoRender\n\n");
        }
        out.write("    }\n");
    }

    private void writeDefines(TechniqueDef techniqueDef, Collection<MatParam> matParams, Writer out) throws IOException {
        out.write("        Defines {\n");
        for (int i = 0; i < techniqueDef.getDefineNames().length; ++i) {
            String matParamName = this.getMatParamNameForDefineId(techniqueDef, matParams, i);
            if (matParamName == null) continue;
            String defineName = techniqueDef.getDefineNames()[i];
            out.write("            ");
            out.write(defineName);
            out.write(": ");
            out.write(matParamName);
            out.write("\n");
        }
        out.write("        }\n\n");
    }

    private void writeShaderNodes(TechniqueDef techniqueDef, Collection<MatParam> matParams, Writer out) throws IOException {
        out.write("        VertexShaderNodes {\n");
        for (ShaderNode shaderNode : techniqueDef.getShaderNodes()) {
            if (shaderNode.getDefinition().getType() != Shader.ShaderType.Vertex) continue;
            this.writeShaderNode(out, shaderNode, matParams);
        }
        out.write("        }\n\n");
        out.write("        FragmentShaderNodes {\n");
        for (ShaderNode shaderNode : techniqueDef.getShaderNodes()) {
            if (shaderNode.getDefinition().getType() != Shader.ShaderType.Fragment) continue;
            this.writeShaderNode(out, shaderNode, matParams);
        }
        out.write("        }\n\n");
    }

    private void writeWorldParams(TechniqueDef techniqueDef, Writer out) throws IOException {
        out.write("        WorldParameters {\n");
        for (UniformBinding uniformBinding : techniqueDef.getWorldBindings()) {
            out.write("            ");
            out.write(uniformBinding.toString());
            out.write("\n");
        }
        out.write("        }\n\n");
    }

    private void writeShaders(TechniqueDef techniqueDef, Writer out) throws IOException {
        if (techniqueDef.getShaderProgramNames().size() > 0) {
            for (Shader.ShaderType shaderType : techniqueDef.getShaderProgramNames().keySet()) {
                out.write("        ");
                out.write(shaderType.name());
                out.write("Shader ");
                out.write(techniqueDef.getShaderProgramLanguage(shaderType));
                out.write(": ");
                out.write((String)techniqueDef.getShaderProgramNames().get(shaderType));
                out.write("\n");
            }
            out.write("\n");
        }
    }

    private void writeShaderNode(Writer out, ShaderNode shaderNode, Collection<MatParam> matParams) throws IOException {
        out.write("            ShaderNode ");
        out.write(shaderNode.getName());
        out.write(" {\n");
        if (shaderNode.getCondition() != null) {
            out.write("                Condition: ");
            out.write(this.formatCondition(shaderNode.getCondition(), matParams));
            out.write("\n");
        }
        out.write("                Definition: ");
        out.write(shaderNode.getDefinition().getName());
        out.write(": ");
        out.write(shaderNode.getDefinition().getPath());
        out.write("\n");
        List inputMapping = shaderNode.getInputMapping();
        List outputMapping = shaderNode.getOutputMapping();
        if (!inputMapping.isEmpty()) {
            out.write("                InputMappings {\n");
            for (VariableMapping mapping : inputMapping) {
                this.writeVariableMapping(out, shaderNode, mapping, matParams);
            }
            out.write("                }\n");
        }
        if (!outputMapping.isEmpty()) {
            out.write("                OutputMappings {\n");
            for (VariableMapping mapping : outputMapping) {
                this.writeVariableMapping(out, shaderNode, mapping, matParams);
            }
            out.write("                }\n");
        }
        out.write("            }\n");
    }

    private void writeVariableMapping(Writer out, ShaderNode shaderNode, VariableMapping mapping, Collection<MatParam> matParams) throws IOException {
        ShaderNodeVariable leftVar = mapping.getLeftVariable();
        ShaderNodeVariable rightVar = mapping.getRightVariable();
        String rightExpression = mapping.getRightExpression();
        out.write("                    ");
        if (!leftVar.getNameSpace().equals(shaderNode.getName())) {
            out.write(leftVar.getNameSpace());
            out.write(".");
        }
        out.write(leftVar.getName());
        if (!mapping.getLeftSwizzling().equals("")) {
            out.write(".");
            out.write(mapping.getLeftSwizzling());
        }
        out.write(" = ");
        if (rightVar != null) {
            String rightVarName;
            if (!rightVar.getNameSpace().equals(shaderNode.getName())) {
                out.write(rightVar.getNameSpace());
                out.write(".");
            }
            if ((rightVarName = rightVar.getName()).startsWith("g_") || rightVarName.startsWith("m_")) {
                rightVarName = rightVarName.substring(2, rightVarName.length());
            }
            out.write(rightVarName);
            if (!mapping.getRightSwizzling().equals("")) {
                out.write(".");
                out.write(mapping.getRightSwizzling());
            }
        } else {
            out.write("%%");
            out.write(rightExpression);
            out.write("%%");
        }
        if (mapping.getCondition() != null) {
            out.write(" : ");
            out.write(this.formatCondition(mapping.getCondition(), matParams));
        }
        out.write("\n");
    }

    private String formatCondition(String condition, Collection<MatParam> matParams) {
        String res = condition;
        Pattern pattern = Pattern.compile("defined\\(([A-Z0-9]*)\\)");
        Matcher m = pattern.matcher(condition);
        while (m.find()) {
            String match = m.group(0);
            String defineName = m.group(1).toLowerCase();
            for (MatParam matParam : matParams) {
                if (!matParam.getName().toLowerCase().equals(defineName)) continue;
                res = res.replace(match, matParam.getName());
            }
        }
        return res;
    }

    private void writeRenderStateAttribute(Writer out, String name, String value) throws IOException {
        out.write("            ");
        out.write(name);
        out.write(" ");
        out.write(value);
        out.write("\n");
    }

    private void writeRenderState(RenderState rs, Writer out) throws IOException {
        RenderState defRs = RenderState.DEFAULT;
        if (rs.getBlendMode() != defRs.getBlendMode()) {
            this.writeRenderStateAttribute(out, "Blend", rs.getBlendMode().name());
        }
        if (rs.isWireframe() != defRs.isWireframe()) {
            this.writeRenderStateAttribute(out, "Wireframe", rs.isWireframe() ? "On" : "Off");
        }
        if (rs.getFaceCullMode() != defRs.getFaceCullMode()) {
            this.writeRenderStateAttribute(out, "FaceCull", rs.getFaceCullMode().name());
        }
        if (rs.isDepthWrite() != defRs.isDepthWrite()) {
            this.writeRenderStateAttribute(out, "DepthWrite", rs.isDepthWrite() ? "On" : "Off");
        }
        if (rs.isDepthTest() != defRs.isDepthTest()) {
            this.writeRenderStateAttribute(out, "DepthTest", rs.isDepthTest() ? "On" : "Off");
        }
        if (rs.getBlendEquation() != defRs.getBlendEquation()) {
            this.writeRenderStateAttribute(out, "BlendEquation", rs.getBlendEquation().name());
        }
        if (rs.getBlendEquationAlpha() != defRs.getBlendEquationAlpha()) {
            this.writeRenderStateAttribute(out, "BlendEquationAlpha", rs.getBlendEquationAlpha().name());
        }
        if (rs.getPolyOffsetFactor() != defRs.getPolyOffsetFactor() || rs.getPolyOffsetUnits() != defRs.getPolyOffsetUnits()) {
            this.writeRenderStateAttribute(out, "PolyOffset", rs.getPolyOffsetFactor() + " " + rs.getPolyOffsetUnits());
        }
        if (rs.isColorWrite() != defRs.isColorWrite()) {
            this.writeRenderStateAttribute(out, "ColorWrite", rs.isColorWrite() ? "On" : "Off");
        }
        if (rs.getDepthFunc() != defRs.getDepthFunc()) {
            this.writeRenderStateAttribute(out, "DepthFunc", rs.getDepthFunc().name());
        }
        if (rs.getLineWidth() != defRs.getLineWidth()) {
            this.writeRenderStateAttribute(out, "LineWidth", Float.toString(rs.getLineWidth()));
        }
    }

    private String getMatParamNameForDefineId(TechniqueDef techniqueDef, Collection<MatParam> matParams, int defineId) {
        for (MatParam matParam : matParams) {
            Integer id = techniqueDef.getShaderParamDefineId(matParam.getName());
            if (id == null || id != defineId) continue;
            return matParam.getName();
        }
        return null;
    }
}

