/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.objects;

import com.jme3.asset.AssetLoadException;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.fbx.SceneLoader;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.objects.FbxNode;
import com.jme3.scene.plugins.fbx.objects.FbxObject;
import com.jme3.scene.plugins.fbx.objects.FbxSkin;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class FbxMesh
extends FbxObject {
    public double[] vertices;
    public int[] indices;
    public int[] edges;
    public String normalsMapping;
    public String normalsReference;
    public double[] normals;
    public String tangentsMapping;
    public String tangentsReference;
    public double[] tangents;
    public String binormalsMapping;
    public String binormalsReference;
    public double[] binormals;
    public String uvMapping;
    public String uvReference;
    public double[] uv;
    public int[] uvIndex;
    public List<int[]> uvIndexes = new ArrayList<int[]>();
    public List<double[]> uvs = new ArrayList<double[]>();
    public String smoothingMapping;
    public String smoothingReference;
    public int[] smoothing;
    public String materialsMapping;
    public String materialsReference;
    public int[] materials;
    public int iCount;
    public int vCount;
    public int srcVertexCount;
    public List<Integer> vertexMap;
    public List<List<Integer>> reverseVertexMap;
    public List<Integer> indexMap;
    public List<Geometry> geometries;
    public FbxNode parent;
    public int lastMaterialId = 0;

    /*
     * Enabled aggressive block sorting
     */
    public FbxMesh(SceneLoader scene, FbxElement element) throws IOException {
        super(scene, element);
        if (this.type.equals("Mesh")) {
            for (FbxElement e : element.children) {
                block9 : switch (e.id) {
                    case "Vertices": {
                        this.vertices = (double[])e.properties.get(0);
                        break;
                    }
                    case "PolygonVertexIndex": {
                        this.indices = (int[])e.properties.get(0);
                        break;
                    }
                    case "LayerElementNormal": {
                        for (FbxElement e2 : e.children) {
                            switch (e2.id) {
                                case "MappingInformationType": {
                                    this.normalsMapping = (String)e2.properties.get(0);
                                    if (this.normalsMapping.equals("ByVertice") || this.normalsMapping.equals("ByPolygonVertex")) break;
                                    break block9;
                                }
                                case "ReferenceInformationType": {
                                    this.normalsReference = (String)e2.properties.get(0);
                                    if (this.normalsReference.equals("Direct")) break;
                                    break block9;
                                }
                                case "Normals": {
                                    this.normals = (double[])e2.properties.get(0);
                                }
                            }
                        }
                        break;
                    }
                    case "LayerElementTangent": {
                        for (FbxElement e2 : e.children) {
                            switch (e2.id) {
                                case "MappingInformationType": {
                                    this.tangentsMapping = (String)e2.properties.get(0);
                                    if (this.tangentsMapping.equals("ByVertice") || this.tangentsMapping.equals("ByPolygonVertex")) break;
                                    break block9;
                                }
                                case "ReferenceInformationType": {
                                    this.tangentsReference = (String)e2.properties.get(0);
                                    if (this.tangentsReference.equals("Direct")) break;
                                    break block9;
                                }
                                case "Tangents": {
                                    this.tangents = (double[])e2.properties.get(0);
                                }
                            }
                        }
                        break;
                    }
                    case "LayerElementBinormal": {
                        for (FbxElement e2 : e.children) {
                            switch (e2.id) {
                                case "MappingInformationType": {
                                    this.binormalsMapping = (String)e2.properties.get(0);
                                    if (this.binormalsMapping.equals("ByVertice") || this.binormalsMapping.equals("ByPolygonVertex")) break;
                                    break block9;
                                }
                                case "ReferenceInformationType": {
                                    this.binormalsReference = (String)e2.properties.get(0);
                                    if (this.binormalsReference.equals("Direct")) break;
                                    break block9;
                                }
                                case "Tangents": {
                                    this.binormals = (double[])e2.properties.get(0);
                                }
                            }
                        }
                        break;
                    }
                    case "LayerElementUV": {
                        block74: for (FbxElement e2 : e.children) {
                            switch (e2.id) {
                                case "MappingInformationType": {
                                    this.uvMapping = (String)e2.properties.get(0);
                                    if (this.uvMapping.equals("ByPolygonVertex")) break;
                                    break block9;
                                }
                                case "ReferenceInformationType": {
                                    this.uvReference = (String)e2.properties.get(0);
                                    if (this.uvReference.equals("IndexToDirect")) break;
                                    break block9;
                                }
                                case "UV": {
                                    this.uv = (double[])e2.properties.get(0);
                                    this.uvs.add(this.uv);
                                    continue block74;
                                }
                                case "UVIndex": {
                                    this.uvIndex = (int[])e2.properties.get(0);
                                    this.uvIndexes.add(this.uvIndex);
                                }
                            }
                        }
                        break;
                    }
                    case "LayerElementMaterial": {
                        for (FbxElement e2 : e.children) {
                            switch (e2.id) {
                                case "MappingInformationType": {
                                    this.materialsMapping = (String)e2.properties.get(0);
                                    if (this.materialsMapping.equals("AllSame") || this.materialsMapping.equals("ByPolygon")) break;
                                    break block9;
                                }
                                case "ReferenceInformationType": {
                                    this.materialsReference = (String)e2.properties.get(0);
                                    if (this.materialsReference.equals("IndexToDirect")) break;
                                    break block9;
                                }
                                case "Materials": {
                                    this.materials = (int[])e2.properties.get(0);
                                }
                            }
                        }
                        break;
                    }
                }
            }
            this.geometries = this.createGeometries();
        }
    }

    public void setParent(Node node) {
        for (int i = 0; i < this.geometries.size(); ++i) {
            Geometry geom = this.geometries.get(i);
            geom.setName(node.getName() + (i > 0 ? "-" + i : ""));
            geom.updateModelBound();
            node.attachChild((Spatial)geom);
        }
    }

    @Override
    public void linkToZero() {
        this.setParent(this.scene.sceneNode);
    }

    public void clearMaterials() {
        for (Geometry g : this.geometries) {
            if (g.getUserData("FBXMaterial") == null) continue;
            g.setUserData("FBXMaterial", null);
        }
    }

    @Override
    public void link(FbxObject otherObject) {
        if (otherObject instanceof FbxSkin) {
            FbxSkin skin = (FbxSkin)otherObject;
            skin.toSkin.add(this);
        }
    }

    private List<Geometry> createGeometries() throws IOException {
        float z;
        float y;
        float x;
        int i;
        int srcCount;
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Triangles);
        if (this.indices != null) {
            int index;
            int i2;
            this.iCount = this.indices.length;
            this.srcVertexCount = this.vertices.length / 3;
            this.vCount = 0;
            int polyVertCount = 0;
            for (i2 = 0; i2 < this.iCount; ++i2) {
                index = this.indices[i2];
                ++polyVertCount;
                if (index >= 0) continue;
                if (polyVertCount == 3) {
                    this.vCount += 3;
                } else if (polyVertCount == 4) {
                    this.vCount += 6;
                } else {
                    throw new AssetLoadException("Unsupported PolygonVertexIndex stride");
                }
                polyVertCount = 0;
            }
            this.vertexMap = new ArrayList<Integer>(this.vCount);
            this.indexMap = new ArrayList<Integer>(this.vCount);
            polyVertCount = 0;
            for (i2 = 0; i2 < this.iCount; ++i2) {
                index = this.indices[i2];
                ++polyVertCount;
                if (index >= 0) continue;
                int lastIndex = -(index + 1);
                if (polyVertCount == 3) {
                    this.vertexMap.add(this.indices[i2 - 2]);
                    this.vertexMap.add(this.indices[i2 - 1]);
                    this.vertexMap.add(lastIndex);
                    this.indexMap.add(i2 - 2);
                    this.indexMap.add(i2 - 1);
                    this.indexMap.add(i2 - 0);
                } else if (polyVertCount == 4) {
                    this.vertexMap.add(this.indices[i2 - 3]);
                    this.vertexMap.add(this.indices[i2 - 2]);
                    this.vertexMap.add(this.indices[i2 - 1]);
                    this.vertexMap.add(this.indices[i2 - 3]);
                    this.vertexMap.add(this.indices[i2 - 1]);
                    this.vertexMap.add(lastIndex);
                    this.indexMap.add(i2 - 3);
                    this.indexMap.add(i2 - 2);
                    this.indexMap.add(i2 - 1);
                    this.indexMap.add(i2 - 3);
                    this.indexMap.add(i2 - 1);
                    this.indexMap.add(i2 - 0);
                }
                polyVertCount = 0;
            }
            this.reverseVertexMap = new ArrayList<List<Integer>>(this.srcVertexCount);
            for (i2 = 0; i2 < this.srcVertexCount; ++i2) {
                this.reverseVertexMap.add(new ArrayList());
            }
            for (i2 = 0; i2 < this.vCount; ++i2) {
                index = this.vertexMap.get(i2);
                this.reverseVertexMap.get(index).add(i2);
            }
        } else {
            this.iCount = this.vCount = this.srcVertexCount;
            this.vertexMap = new ArrayList<Integer>(this.vCount);
            this.indexMap = new ArrayList<Integer>(this.vCount);
            this.reverseVertexMap = new ArrayList<List<Integer>>(this.vCount);
            for (int i3 = 0; i3 < this.vCount; ++i3) {
                this.vertexMap.set(i3, i3);
                this.indexMap.set(i3, i3);
                ArrayList<Integer> l = new ArrayList<Integer>(1);
                l.add(i3);
                this.reverseVertexMap.add(l);
            }
        }
        if (this.vertices != null) {
            FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((int)(this.vCount * 3));
            mesh.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
            int srcCount2 = this.vertices.length / 3;
            for (int i4 = 0; i4 < this.vCount; ++i4) {
                int index = this.vertexMap.get(i4);
                if (index > srcCount2) {
                    throw new AssetLoadException("Invalid vertex mapping. Unexpected lookup vertex " + index + " from " + srcCount2);
                }
                float x2 = (float)this.vertices[3 * index + 0] / this.scene.unitSize * (float)this.scene.xAxis;
                float y2 = (float)this.vertices[3 * index + 1] / this.scene.unitSize * (float)this.scene.yAxis;
                float z2 = (float)this.vertices[3 * index + 2] / this.scene.unitSize * (float)this.scene.zAxis;
                positionBuffer.put(x2).put(y2).put(z2);
            }
        }
        if (this.normals != null) {
            FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)(this.vCount * 3));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, normalBuffer);
            List<Integer> mapping = null;
            if (this.normalsMapping.equals("ByVertice")) {
                mapping = this.vertexMap;
            } else if (this.normalsMapping.equals("ByPolygonVertex")) {
                mapping = this.indexMap;
            } else {
                throw new IOException("Unknown normals mapping type: " + this.normalsMapping);
            }
            srcCount = this.normals.length / 3;
            for (i = 0; i < this.vCount; ++i) {
                int index = mapping.get(i);
                if (index > srcCount) {
                    throw new AssetLoadException("Invalid normal mapping. Unexpected lookup normal " + index + " from " + srcCount);
                }
                x = (float)this.normals[3 * index + 0] * (float)this.scene.xAxis;
                y = (float)this.normals[3 * index + 1] * (float)this.scene.yAxis;
                z = (float)this.normals[3 * index + 2] * (float)this.scene.zAxis;
                normalBuffer.put(x).put(y).put(z);
            }
        }
        if (this.tangents != null) {
            FloatBuffer tangentBuffer = BufferUtils.createFloatBuffer((int)(this.vCount * 4));
            mesh.setBuffer(VertexBuffer.Type.Tangent, 4, tangentBuffer);
            List<Integer> mapping = null;
            if (this.tangentsMapping.equals("ByVertice")) {
                mapping = this.vertexMap;
            } else if (this.tangentsMapping.equals("ByPolygonVertex")) {
                mapping = this.indexMap;
            } else {
                throw new IOException("Unknown tangents mapping type: " + this.tangentsMapping);
            }
            srcCount = this.tangents.length / 3;
            for (i = 0; i < this.vCount; ++i) {
                int index = mapping.get(i);
                if (index > srcCount) {
                    throw new AssetLoadException("Invalid tangent mapping. Unexpected lookup tangent " + index + " from " + srcCount);
                }
                x = (float)this.tangents[3 * index + 0] * (float)this.scene.xAxis;
                y = (float)this.tangents[3 * index + 1] * (float)this.scene.yAxis;
                z = (float)this.tangents[3 * index + 2] * (float)this.scene.zAxis;
                tangentBuffer.put(x).put(y).put(z).put(-1.0f);
            }
        }
        if (this.binormals != null) {
            FloatBuffer binormalBuffer = BufferUtils.createFloatBuffer((int)(this.vCount * 3));
            mesh.setBuffer(VertexBuffer.Type.Binormal, 3, binormalBuffer);
            List<Integer> mapping = null;
            if (this.binormalsMapping.equals("ByVertice")) {
                mapping = this.vertexMap;
            } else if (this.binormalsMapping.equals("ByPolygonVertex")) {
                mapping = this.indexMap;
            } else {
                throw new IOException("Unknown binormals mapping type: " + this.binormalsMapping);
            }
            srcCount = this.binormals.length / 3;
            for (i = 0; i < this.vCount; ++i) {
                int index = mapping.get(i);
                if (index > srcCount) {
                    throw new AssetLoadException("Invalid binormal mapping. Unexpected lookup binormal " + index + " from " + srcCount);
                }
                x = (float)this.binormals[3 * index + 0] * (float)this.scene.xAxis;
                y = (float)this.binormals[3 * index + 1] * (float)this.scene.yAxis;
                z = (float)this.binormals[3 * index + 2] * (float)this.scene.zAxis;
                binormalBuffer.put(x).put(y).put(z);
            }
        }
        for (int uvLayer = 0; uvLayer < this.uvs.size(); ++uvLayer) {
            double[] uv = this.uvs.get(uvLayer);
            int[] uvIndex = this.uvIndexes.size() > uvLayer ? this.uvIndexes.get(uvLayer) : null;
            List<Integer> unIndexMap = this.vertexMap;
            if (uvIndex != null) {
                int uvIndexSrcCount = uvIndex.length;
                if (uvIndexSrcCount != this.iCount) {
                    throw new AssetLoadException("Invalid number of texcoord index data " + uvIndexSrcCount + " expected " + this.iCount);
                }
                unIndexMap = new ArrayList<Integer>(this.vCount);
                int polyVertCount = 0;
                for (int i5 = 0; i5 < this.iCount; ++i5) {
                    int index = this.indices[i5];
                    ++polyVertCount;
                    if (index >= 0) continue;
                    if (polyVertCount == 3) {
                        unIndexMap.add(uvIndex[i5 - 2]);
                        unIndexMap.add(uvIndex[i5 - 1]);
                        unIndexMap.add(uvIndex[i5 - 0]);
                    } else if (polyVertCount == 4) {
                        unIndexMap.add(uvIndex[i5 - 3]);
                        unIndexMap.add(uvIndex[i5 - 2]);
                        unIndexMap.add(uvIndex[i5 - 1]);
                        unIndexMap.add(uvIndex[i5 - 3]);
                        unIndexMap.add(uvIndex[i5 - 1]);
                        unIndexMap.add(uvIndex[i5 - 0]);
                    }
                    polyVertCount = 0;
                }
            }
            FloatBuffer uvBuffer = BufferUtils.createFloatBuffer((int)(this.vCount * 2));
            VertexBuffer.Type type = VertexBuffer.Type.TexCoord;
            switch (uvLayer) {
                case 1: {
                    type = VertexBuffer.Type.TexCoord2;
                    break;
                }
                case 2: {
                    type = VertexBuffer.Type.TexCoord3;
                    break;
                }
                case 3: {
                    type = VertexBuffer.Type.TexCoord4;
                    break;
                }
                case 4: {
                    type = VertexBuffer.Type.TexCoord5;
                    break;
                }
                case 5: {
                    type = VertexBuffer.Type.TexCoord6;
                    break;
                }
                case 6: {
                    type = VertexBuffer.Type.TexCoord7;
                    break;
                }
                case 7: {
                    type = VertexBuffer.Type.TexCoord8;
                }
            }
            mesh.setBuffer(type, 2, uvBuffer);
            int srcCount3 = uv.length / 2;
            for (int i6 = 0; i6 < this.vCount; ++i6) {
                int index = unIndexMap.get(i6);
                if (index > srcCount3) {
                    throw new AssetLoadException("Invalid texcoord mapping. Unexpected lookup texcoord " + index + " from " + srcCount3);
                }
                float u = index >= 0 ? (float)uv[2 * index + 0] : 0.0f;
                float v = index >= 0 ? (float)uv[2 * index + 1] : 0.0f;
                uvBuffer.put(u).put(v);
            }
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.materialsReference.equals("IndexToDirect") && this.materialsMapping.equals("ByPolygon")) {
            IntMap indexBuffers = new IntMap();
            for (int polygon = 0; polygon < this.materials.length; ++polygon) {
                int material = this.materials[polygon];
                ArrayList<Integer> list = (ArrayList<Integer>)indexBuffers.get(material);
                if (list == null) {
                    list = new ArrayList<Integer>();
                    indexBuffers.put(material, list);
                }
                list.add(polygon * 3 + 0);
                list.add(polygon * 3 + 1);
                list.add(polygon * 3 + 2);
            }
            for (IntMap.Entry e : indexBuffers) {
                int materialId = e.getKey();
                List indexes = (List)e.getValue();
                Mesh newMesh = mesh.clone();
                newMesh.setBuffer(VertexBuffer.Type.Index, 3, FbxMesh.toArray(indexes.toArray(new Integer[indexes.size()])));
                newMesh.setStatic();
                newMesh.updateBound();
                newMesh.updateCounts();
                Geometry geom = new Geometry();
                geom.setMesh(newMesh);
                geometries.add(geom);
                geom.setUserData("FBXMaterial", (Object)materialId);
            }
        } else {
            mesh.setStatic();
            mesh.updateBound();
            mesh.updateCounts();
            Geometry geom = new Geometry();
            geom.setMesh(mesh);
            geometries.add(geom);
        }
        return geometries;
    }

    private static int[] toArray(Integer[] arr) {
        int[] ret = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = arr[i];
        }
        return ret;
    }
}

