/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre.matext;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.scene.plugins.ogre.matext.MaterialExtension;
import com.jme3.scene.plugins.ogre.matext.MaterialExtensionSet;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.PlaceholderAssets;
import com.jme3.util.blockparser.Statement;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialExtensionLoader {
    private static final Logger logger = Logger.getLogger(MaterialExtensionLoader.class.getName());
    private AssetKey key;
    private AssetManager assetManager;
    private MaterialList list;
    private MaterialExtensionSet matExts;
    private MaterialExtension matExt;
    private String matName;
    private Material material;

    private void readExtendingMaterialStatement(Statement statement) throws IOException {
        if (statement.getLine().startsWith("set_texture_alias")) {
            Texture tex;
            String[] split = statement.getLine().split(" ", 3);
            String aliasName = split[1];
            String texturePath = split[2];
            String jmeParamName = this.matExt.getTextureMapping(aliasName);
            TextureKey texKey = new TextureKey(texturePath, false);
            texKey.setGenerateMips(true);
            try {
                tex = this.assetManager.loadTexture(texKey);
                tex.setWrap(Texture.WrapMode.Repeat);
            }
            catch (AssetNotFoundException ex) {
                logger.log(Level.WARNING, "Cannot locate {0} for material {1}", new Object[]{texKey, this.key});
                tex = new Texture2D(PlaceholderAssets.getPlaceholderImage((AssetManager)this.assetManager));
                tex.setWrap(Texture.WrapMode.Repeat);
                tex.setKey((AssetKey)texKey);
            }
            this.material.setTexture(jmeParamName, tex);
        }
    }

    private Material readExtendingMaterial(Statement statement) throws IOException {
        String[] split = statement.getLine().split(" ", 2);
        String[] subsplit = split[1].split(":");
        this.matName = subsplit[0].trim();
        String extendedMat = subsplit[1].trim();
        this.matExt = this.matExts.getMaterialExtension(extendedMat);
        if (this.matExt == null) {
            logger.log(Level.WARNING, "Cannot find MaterialExtension for: {0}. Ignoring material.", extendedMat);
            this.matExt = null;
            return null;
        }
        this.material = new Material(this.assetManager, this.matExt.getJmeMatDefName());
        this.material.setName(this.matName);
        for (Statement extMatStat : statement.getContents()) {
            this.readExtendingMaterialStatement(extMatStat);
        }
        return this.material;
    }

    public MaterialList load(AssetManager assetManager, AssetKey key, MaterialExtensionSet matExts, List<Statement> statements) throws IOException {
        this.assetManager = assetManager;
        this.matExts = matExts;
        this.key = key;
        this.list = new MaterialList();
        for (Statement statement : statements) {
            if (statement.getLine().startsWith("import") || !statement.getLine().startsWith("material")) continue;
            Material material = this.readExtendingMaterial(statement);
            this.list.put((Object)this.matName, (Object)material);
            List<String> matAliases = matExts.getNameMappings(this.matName);
            if (matAliases == null) continue;
            for (String string : matAliases) {
                this.list.put((Object)string, (Object)material);
            }
        }
        return this.list;
    }
}

