/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimTrack;
import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class AnimFactory {
    private final float duration;
    private final float fps;
    private final Map<Float, Quaternion> rotations = new TreeMap<Float, Quaternion>();
    private final Map<Float, Vector3f> scales = new TreeMap<Float, Vector3f>();
    private final Map<Float, Vector3f> translations = new TreeMap<Float, Vector3f>();
    private final String name;

    public AnimFactory(float duration, String name, float fps) {
        if (!(duration > 0.0f)) {
            throw new IllegalArgumentException("duration must be positive");
        }
        if (!(fps > 0.0f)) {
            throw new IllegalArgumentException("FPS must be positive");
        }
        this.name = name;
        this.duration = duration;
        this.fps = fps;
        Transform transform = new Transform();
        this.translations.put(Float.valueOf(0.0f), transform.getTranslation());
        this.rotations.put(Float.valueOf(0.0f), transform.getRotation());
        this.scales.put(Float.valueOf(0.0f), transform.getScale());
    }

    public void addKeyFrameRotation(int keyFrameIndex, Quaternion rotation) {
        float animationTime = (float)keyFrameIndex / this.fps;
        this.addTimeRotation(animationTime, rotation);
    }

    public void addKeyFrameScale(int keyFrameIndex, Vector3f scale) {
        float animationTime = (float)keyFrameIndex / this.fps;
        this.addTimeScale(animationTime, scale);
    }

    public void addKeyFrameTransform(int keyFrameIndex, Transform transform) {
        float time = (float)keyFrameIndex / this.fps;
        this.addTimeTransform(time, transform);
    }

    public void addKeyFrameTranslation(int keyFrameIndex, Vector3f offset) {
        float time = (float)keyFrameIndex / this.fps;
        this.addTimeTranslation(time, offset);
    }

    public void addTimeRotation(float time, Quaternion rotation) {
        if (!(time >= 0.0f) || !(time <= this.duration)) {
            throw new IllegalArgumentException("animation time out of range");
        }
        float norm = rotation.norm();
        if (norm == 0.0f) {
            throw new IllegalArgumentException("rotation cannot have norm=0");
        }
        float normalizingFactor = 1.0f / FastMath.sqrt(norm);
        Quaternion normalized = rotation.mult(normalizingFactor);
        this.rotations.put(Float.valueOf(time), normalized);
    }

    public void addTimeRotation(float time, float xAngle, float yAngle, float zAngle) {
        if (!(time >= 0.0f) || !(time <= this.duration)) {
            throw new IllegalArgumentException("animation time out of range");
        }
        Quaternion quat = new Quaternion().fromAngles(xAngle, yAngle, zAngle);
        this.rotations.put(Float.valueOf(time), quat);
    }

    public void addTimeScale(float time, Vector3f scale) {
        if (!(time >= 0.0f) || !(time <= this.duration)) {
            throw new IllegalArgumentException("animation time out of range");
        }
        Vector3f clone = scale.clone();
        this.scales.put(Float.valueOf(time), clone);
    }

    public void addTimeTransform(float time, Transform transform) {
        if (!(time >= 0.0f) || !(time <= this.duration)) {
            throw new IllegalArgumentException("animation time out of range");
        }
        Vector3f translation = transform.getTranslation(null);
        this.translations.put(Float.valueOf(time), translation);
        this.rotations.put(Float.valueOf(time), transform.getRotation(null));
        this.scales.put(Float.valueOf(time), transform.getScale(null));
    }

    public void addTimeTranslation(float time, Vector3f offset) {
        if (!(time >= 0.0f) || !(time <= this.duration)) {
            throw new IllegalArgumentException("animation time out of range");
        }
        Vector3f clone = offset.clone();
        this.translations.put(Float.valueOf(time), clone);
    }

    public AnimClip buildAnimation(HasLocalTransform target) {
        float time;
        TreeSet<Float> times = new TreeSet<Float>();
        int frameI = 0;
        while (!((time = (float)frameI / this.fps) > this.duration)) {
            times.add(Float.valueOf(time));
            ++frameI;
        }
        times.addAll(this.rotations.keySet());
        times.addAll(this.scales.keySet());
        times.addAll(this.translations.keySet());
        int numFrames = times.size();
        float[] timeArray = new float[numFrames];
        Vector3f[] translateArray = new Vector3f[numFrames];
        Quaternion[] rotArray = new Quaternion[numFrames];
        Vector3f[] scaleArray = new Vector3f[numFrames];
        int iFrame = 0;
        Iterator iterator = times.iterator();
        while (iterator.hasNext()) {
            float time2;
            timeArray[iFrame] = time2 = ((Float)iterator.next()).floatValue();
            translateArray[iFrame] = this.interpolateTranslation(time2);
            rotArray[iFrame] = this.interpolateRotation(time2);
            scaleArray[iFrame] = this.interpolateScale(time2);
            ++iFrame;
        }
        AnimTrack[] tracks = new AnimTrack[]{new TransformTrack(target, timeArray, translateArray, rotArray, scaleArray)};
        AnimClip result = new AnimClip(this.name);
        result.setTracks(tracks);
        return result;
    }

    private Quaternion interpolateRotation(float keyFrameTime) {
        assert (keyFrameTime >= 0.0f && keyFrameTime <= this.duration);
        float prev = 0.0f;
        float next = this.duration;
        for (float key : this.rotations.keySet()) {
            if (key <= keyFrameTime && key > prev) {
                prev = key;
            }
            if (!(key >= keyFrameTime) || !(key < next)) continue;
            next = key;
        }
        assert (prev <= next);
        Quaternion prevRotation = this.rotations.get(Float.valueOf(prev));
        Quaternion result = new Quaternion();
        if (prev == next || !this.rotations.containsKey(Float.valueOf(next))) {
            result.set(prevRotation);
        } else {
            float fraction = (keyFrameTime - prev) / (next - prev);
            assert (fraction >= 0.0f && fraction <= 1.0f);
            Quaternion nextRotation = this.rotations.get(Float.valueOf(next));
            result.slerp(prevRotation, nextRotation, fraction);
        }
        return result;
    }

    private Vector3f interpolateScale(float keyFrameTime) {
        assert (keyFrameTime >= 0.0f && keyFrameTime <= this.duration);
        float prev = 0.0f;
        float next = this.duration;
        for (float key : this.scales.keySet()) {
            if (key <= keyFrameTime && key > prev) {
                prev = key;
            }
            if (!(key >= keyFrameTime) || !(key < next)) continue;
            next = key;
        }
        assert (prev <= next);
        Vector3f prevScale = this.scales.get(Float.valueOf(prev));
        Vector3f result = new Vector3f();
        if (prev == next || !this.scales.containsKey(Float.valueOf(next))) {
            result.set(prevScale);
        } else {
            float fraction = (keyFrameTime - prev) / (next - prev);
            assert (fraction >= 0.0f && fraction <= 1.0f);
            Vector3f nextScale = this.scales.get(Float.valueOf(next));
            result.interpolateLocal(prevScale, nextScale, fraction);
        }
        return result;
    }

    private Vector3f interpolateTranslation(float keyFrameTime) {
        float prev = 0.0f;
        float next = this.duration;
        for (float key : this.translations.keySet()) {
            if (key <= keyFrameTime && key > prev) {
                prev = key;
            }
            if (!(key >= keyFrameTime) || !(key < next)) continue;
            next = key;
        }
        assert (prev <= next);
        Vector3f prevTranslation = this.translations.get(Float.valueOf(prev));
        Vector3f result = new Vector3f();
        if (prev == next || !this.translations.containsKey(Float.valueOf(next))) {
            result.set(prevTranslation);
        } else {
            float fraction = (keyFrameTime - prev) / (next - prev);
            assert (fraction >= 0.0f && fraction <= 1.0f);
            Vector3f nextTranslation = this.translations.get(Float.valueOf(next));
            result.interpolateLocal(prevTranslation, nextTranslation, fraction);
        }
        return result;
    }
}

