/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.AnimationMask;
import com.jme3.anim.tween.action.Action;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;

public class AnimLayer
implements JmeCloneable {
    private Action currentAction;
    private AnimComposer composer;
    private final AnimationMask mask;
    private double time;
    private Object manager;
    private final String name;

    AnimLayer(AnimComposer composer, String name, AnimationMask mask) {
        assert (composer != null);
        this.composer = composer;
        assert (name != null);
        this.name = name;
        this.mask = mask;
    }

    public Action getCurrentAction() {
        return this.currentAction;
    }

    public Object getManager() {
        return this.manager;
    }

    public AnimationMask getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public double getTime() {
        return this.time;
    }

    public void setCurrentAction(Action actionToRun) {
        this.time = 0.0;
        this.currentAction = actionToRun;
    }

    public void setManager(Object manager) {
        this.manager = manager;
    }

    public void setTime(double animationTime) {
        double length = this.currentAction.getLength();
        this.time = animationTime >= 0.0 ? animationTime % length : animationTime % length + length;
    }

    void update(float appDeltaTimeInSeconds) {
        Action action = this.currentAction;
        if (action == null) {
            return;
        }
        double speedup = action.getSpeed() * (double)this.composer.getGlobalSpeed();
        double scaledDeltaTime = speedup * (double)appDeltaTimeInSeconds;
        this.time += scaledDeltaTime;
        if (this.time < 0.0) {
            double length = action.getLength();
            this.time = (this.time % length + length) % length;
        }
        action.setMask(this.mask);
        boolean running = action.interpolate(this.time);
        action.setMask(null);
        if (!running) {
            this.time = 0.0;
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.composer = cloner.clone(this.composer);
        this.currentAction = null;
    }

    @Override
    public Object jmeClone() {
        try {
            AnimLayer clone = (AnimLayer)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError();
        }
    }
}

