/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.tween.action;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimTrack;
import com.jme3.anim.MorphTrack;
import com.jme3.anim.TransformTrack;
import com.jme3.anim.tween.Tween;
import com.jme3.anim.tween.action.BlendableAction;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.math.Transform;
import com.jme3.scene.Geometry;
import com.jme3.util.clone.Cloner;
import java.util.ArrayList;
import java.util.Collection;

public class ClipAction
extends BlendableAction {
    private AnimClip clip;
    private Transform transform = new Transform();

    public ClipAction(AnimClip clip) {
        super(new Tween[0]);
        this.clip = clip;
        this.setLength(clip.getLength());
    }

    @Override
    public void doInterpolate(double t) {
        AnimTrack[] tracks;
        for (AnimTrack track : tracks = this.clip.getTracks()) {
            if (track instanceof TransformTrack) {
                TransformTrack tt = (TransformTrack)track;
                if (this.getMask() != null && !this.getMask().contains(tt.getTarget())) continue;
                this.interpolateTransformTrack(t, tt);
                continue;
            }
            if (!(track instanceof MorphTrack)) continue;
            this.interpolateMorphTrack(t, (MorphTrack)track);
        }
    }

    private void interpolateTransformTrack(double t, TransformTrack track) {
        HasLocalTransform target = track.getTarget();
        this.transform.set(target.getLocalTransform());
        track.getDataAtTime(t, this.transform);
        if (this.collectTransformDelegate != null) {
            this.collectTransformDelegate.collectTransform(target, this.transform, this.getWeight(), this);
        } else {
            this.collectTransform(target, this.transform, this.getTransitionWeight(), this);
        }
    }

    private void interpolateMorphTrack(double t, MorphTrack track) {
        Geometry target = track.getTarget();
        float[] weights = target.getMorphState();
        track.getDataAtTime(t, weights);
        target.setMorphState(weights);
    }

    public void reset() {
    }

    public String toString() {
        return this.clip.toString();
    }

    @Override
    public Collection<HasLocalTransform> getTargets() {
        ArrayList<HasLocalTransform> targets = new ArrayList<HasLocalTransform>(this.clip.getTracks().length);
        for (AnimTrack track : this.clip.getTracks()) {
            if (!(track instanceof TransformTrack)) continue;
            targets.add(((TransformTrack)track).getTarget());
        }
        return targets;
    }

    @Override
    public void collectTransform(HasLocalTransform target, Transform t, float weight, BlendableAction source) {
        if (weight == 1.0f) {
            target.setLocalTransform(t);
        } else {
            Transform tr = target.getLocalTransform();
            tr.interpolateTransforms(tr, t, weight);
            target.setLocalTransform(tr);
        }
    }

    @Override
    public ClipAction jmeClone() {
        try {
            ClipAction clone = (ClipAction)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.clip = cloner.clone(this.clip);
        this.transform = cloner.clone(this.transform);
    }
}

