/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetProcessor;
import com.jme3.asset.cache.AssetCache;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ImplHandler {
    private static final Logger logger = Logger.getLogger(ImplHandler.class.getName());
    private final AssetManager assetManager;
    private final ThreadLocal<AssetKey> parentAssetKey = new ThreadLocal();
    private final CopyOnWriteArrayList<ImplThreadLocal<AssetLocator>> locatorsList = new CopyOnWriteArrayList();
    private final HashMap<Class<?>, ImplThreadLocal<AssetLoader>> classToLoaderMap = new HashMap();
    private final ConcurrentHashMap<String, ImplThreadLocal<AssetLoader>> extensionToLoaderMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends AssetProcessor>, AssetProcessor> classToProcMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends AssetCache>, AssetCache> classToCacheMap = new ConcurrentHashMap();

    public ImplHandler(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public void establishParentKey(AssetKey parentKey) {
        if (this.parentAssetKey.get() == null) {
            this.parentAssetKey.set(parentKey);
        }
    }

    public void releaseParentKey(AssetKey parentKey) {
        if (this.parentAssetKey.get() == parentKey) {
            this.parentAssetKey.set(null);
        }
    }

    public AssetKey getParentKey() {
        return this.parentAssetKey.get();
    }

    public AssetInfo tryLocate(AssetKey key) {
        if (this.locatorsList.isEmpty()) {
            logger.warning("There are no locators currently registered. Use AssetManager.registerLocator() to register a locator.");
            return null;
        }
        for (ImplThreadLocal<AssetLocator> local : this.locatorsList) {
            AssetInfo info = ((AssetLocator)local.get()).locate(this.assetManager, key);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    public int getLocatorCount() {
        return this.locatorsList.size();
    }

    public AssetLoader aquireLoader(AssetKey key) {
        ImplThreadLocal<AssetLoader> local = this.extensionToLoaderMap.get(key.getExtension());
        if (local == null) {
            throw new AssetLoadException("No loader registered for type \"" + key.getExtension() + "\"");
        }
        return (AssetLoader)local.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        ConcurrentHashMap<Class<? extends AssetCache>, AssetCache> concurrentHashMap = this.classToCacheMap;
        synchronized (concurrentHashMap) {
            for (AssetCache cache : this.classToCacheMap.values()) {
                cache.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AssetCache> T getCache(Class<T> cacheClass) {
        if (cacheClass == null) {
            return null;
        }
        AssetCache cache = this.classToCacheMap.get(cacheClass);
        if (cache == null) {
            ConcurrentHashMap<Class<? extends AssetCache>, AssetCache> concurrentHashMap = this.classToCacheMap;
            synchronized (concurrentHashMap) {
                cache = this.classToCacheMap.get(cacheClass);
                if (cache == null) {
                    try {
                        cache = (AssetCache)cacheClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.classToCacheMap.put(cacheClass, cache);
                    }
                    catch (IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        throw new IllegalArgumentException("The cache class cannot be created, ensure it has empty constructor", ex);
                    }
                    catch (IllegalAccessException | SecurityException ex) {
                        throw new IllegalArgumentException("The cache class cannot be accessed", ex);
                    }
                }
            }
        }
        return (T)cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AssetProcessor> T getProcessor(Class<T> procClass) {
        if (procClass == null) {
            return null;
        }
        AssetProcessor proc = this.classToProcMap.get(procClass);
        if (proc == null) {
            ConcurrentHashMap<Class<? extends AssetProcessor>, AssetProcessor> concurrentHashMap = this.classToProcMap;
            synchronized (concurrentHashMap) {
                proc = this.classToProcMap.get(procClass);
                if (proc == null) {
                    try {
                        proc = (AssetProcessor)procClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.classToProcMap.put(procClass, proc);
                    }
                    catch (IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        throw new IllegalArgumentException("The processor class cannot be created, ensure it has empty constructor", ex);
                    }
                    catch (IllegalAccessException | SecurityException ex) {
                        throw new IllegalArgumentException("The processor class cannot be accessed", ex);
                    }
                }
            }
        }
        return (T)proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoader(Class<? extends AssetLoader> loaderType, String ... extensions) {
        ImplThreadLocal<? extends AssetLoader> local = new ImplThreadLocal<AssetLoader>(loaderType, extensions);
        for (String extension : extensions) {
            extension = extension.toLowerCase();
            HashMap<Class<?>, ImplThreadLocal<AssetLoader>> hashMap = this.classToLoaderMap;
            synchronized (hashMap) {
                this.classToLoaderMap.put(loaderType, local);
                this.extensionToLoaderMap.put(extension, local);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoader(Class<? extends AssetLoader> loaderType) {
        HashMap<Class<?>, ImplThreadLocal<AssetLoader>> hashMap = this.classToLoaderMap;
        synchronized (hashMap) {
            ImplThreadLocal<AssetLoader> local = this.classToLoaderMap.remove(loaderType);
            if (local == null) {
                return;
            }
            for (String extension : local.getExtensions()) {
                this.extensionToLoaderMap.remove(extension);
            }
        }
    }

    public void addLocator(Class<? extends AssetLocator> locatorType, String rootPath) {
        this.locatorsList.add(new ImplThreadLocal<AssetLocator>(locatorType, rootPath));
    }

    public void removeLocator(Class<? extends AssetLocator> locatorType, String rootPath) {
        ArrayList<ImplThreadLocal<AssetLocator>> locatorsToRemove = new ArrayList<ImplThreadLocal<AssetLocator>>();
        for (ImplThreadLocal<AssetLocator> locator : this.locatorsList) {
            if (!locator.getPath().equals(rootPath) || !locator.getTypeClass().equals(locatorType)) continue;
            locatorsToRemove.add(locator);
        }
        this.locatorsList.removeAll(locatorsToRemove);
    }

    protected static class ImplThreadLocal<T>
    extends ThreadLocal<T> {
        private final Class<T> type;
        private final String path;
        private final String[] extensions;

        public ImplThreadLocal(Class<T> type, String[] extensions) {
            this.type = type;
            this.extensions = (String[])extensions.clone();
            this.path = null;
        }

        public ImplThreadLocal(Class<T> type, String path) {
            this.type = type;
            this.path = path;
            this.extensions = null;
        }

        public ImplThreadLocal(Class<T> type) {
            this.type = type;
            this.path = null;
            this.extensions = null;
        }

        public String getPath() {
            return this.path;
        }

        public String[] getExtensions() {
            return this.extensions;
        }

        public Class<?> getTypeClass() {
            return this.type;
        }

        @Override
        protected T initialValue() {
            try {
                T obj = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (this.path != null) {
                    ((AssetLocator)obj).setRootPath(this.path);
                }
                return obj;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, "Cannot create locator of type {0}, does the class have an empty and publicly accessible constructor?", this.type.getName());
                logger.throwing(this.type.getName(), "<init>", ex);
                return null;
            }
        }
    }
}

