/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.effect.influencers;

import com.jme3.effect.Particle;
import com.jme3.effect.influencers.ParticleInfluencer;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public class DefaultParticleInfluencer
implements ParticleInfluencer {
    public static final int SAVABLE_VERSION = 1;
    protected transient Vector3f temp = new Vector3f();
    protected Vector3f initialVelocity = new Vector3f();
    protected float velocityVariation = 0.2f;

    @Override
    public void influenceParticle(Particle particle, EmitterShape emitterShape) {
        emitterShape.getRandomPoint(particle.position);
        this.applyVelocityVariation(particle);
    }

    protected void applyVelocityVariation(Particle particle) {
        particle.velocity.set(this.initialVelocity);
        this.temp.set(FastMath.nextRandomFloat(), FastMath.nextRandomFloat(), FastMath.nextRandomFloat());
        this.temp.multLocal(2.0f);
        this.temp.subtractLocal(1.0f, 1.0f, 1.0f);
        this.temp.multLocal(this.initialVelocity.length());
        particle.velocity.interpolateLocal(this.temp, this.velocityVariation);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.initialVelocity, "initialVelocity", Vector3f.ZERO);
        oc.write(this.velocityVariation, "variation", 0.2f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.initialVelocity = ic.getSavableVersion(DefaultParticleInfluencer.class) == 0 ? (Vector3f)ic.readSavable("startVelocity", Vector3f.ZERO.clone()) : (Vector3f)ic.readSavable("initialVelocity", Vector3f.ZERO.clone());
        this.velocityVariation = ic.readFloat("variation", 0.2f);
    }

    @Override
    public DefaultParticleInfluencer clone() {
        try {
            DefaultParticleInfluencer clone = (DefaultParticleInfluencer)super.clone();
            clone.initialVelocity = this.initialVelocity.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.initialVelocity = cloner.clone(this.initialVelocity);
        this.temp = cloner.clone(this.temp);
    }

    @Override
    public void setInitialVelocity(Vector3f initialVelocity) {
        this.initialVelocity.set(initialVelocity);
    }

    @Override
    public Vector3f getInitialVelocity() {
        return this.initialVelocity;
    }

    @Override
    public void setVelocityVariation(float variation) {
        this.velocityVariation = variation;
    }

    @Override
    public float getVelocityVariation() {
        return this.velocityVariation;
    }
}

