/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.bounding.Intersection;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Plane;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import java.io.IOException;

public class SpotLight
extends Light {
    protected Vector3f position = new Vector3f();
    protected Vector3f direction = new Vector3f(0.0f, -1.0f, 0.0f);
    protected float spotInnerAngle = 0.09817477f;
    protected float spotOuterAngle = 0.1308997f;
    protected float spotRange = 100.0f;
    protected float invSpotRange = 0.01f;
    protected float packedAngleCos = 0.0f;
    protected float outerAngleCosSqr;
    protected float outerAngleSinSqr;
    protected float outerAngleSinRcp;
    protected float outerAngleSin;
    protected float outerAngleCos;

    public SpotLight() {
        this.computeAngleParameters();
    }

    public SpotLight(Vector3f position, Vector3f direction) {
        this();
        this.setPosition(position);
        this.setDirection(direction);
    }

    public SpotLight(Vector3f position, Vector3f direction, float range) {
        this();
        this.setPosition(position);
        this.setDirection(direction);
        this.setSpotRange(range);
    }

    public SpotLight(Vector3f position, Vector3f direction, ColorRGBA color) {
        super(color);
        this.computeAngleParameters();
        this.setPosition(position);
        this.setDirection(direction);
    }

    public SpotLight(Vector3f position, Vector3f direction, float range, ColorRGBA color) {
        super(color);
        this.computeAngleParameters();
        this.setPosition(position);
        this.setDirection(direction);
        this.setSpotRange(range);
    }

    public SpotLight(Vector3f position, Vector3f direction, float range, ColorRGBA color, float innerAngle, float outerAngle) {
        super(color);
        this.spotInnerAngle = innerAngle;
        this.spotOuterAngle = outerAngle;
        this.computeAngleParameters();
        this.setPosition(position);
        this.setDirection(direction);
        this.setSpotRange(range);
    }

    private void computeAngleParameters() {
        float innerCos = FastMath.cos(this.spotInnerAngle);
        this.outerAngleCos = FastMath.cos(this.spotOuterAngle);
        this.packedAngleCos = (int)(innerCos * 1000.0f);
        if ((int)this.packedAngleCos == (int)(this.outerAngleCos * 1000.0f)) {
            this.outerAngleCos -= 0.001f;
        }
        this.packedAngleCos += this.outerAngleCos;
        if (this.packedAngleCos == 0.0f) {
            throw new IllegalArgumentException("Packed angle cosine is invalid");
        }
        this.outerAngleSin = FastMath.sin(this.spotOuterAngle);
        this.outerAngleCosSqr = this.outerAngleCos * this.outerAngleCos;
        this.outerAngleSinSqr = this.outerAngleSin * this.outerAngleSin;
        this.outerAngleSinRcp = 1.0f / this.outerAngleSin;
    }

    @Override
    public boolean intersectsBox(BoundingBox box, TempVars vars) {
        if (this.spotRange > 0.0f && !Intersection.intersect(box, this.position, this.spotRange)) {
            return false;
        }
        Vector3f otherCenter = box.getCenter();
        Vector3f radVect = vars.vect4;
        radVect.set(box.getXExtent(), box.getYExtent(), box.getZExtent());
        float otherRadiusSquared = radVect.lengthSquared();
        float otherRadius = FastMath.sqrt(otherRadiusSquared);
        Vector3f E = this.direction.mult(otherRadius * this.outerAngleSinRcp, vars.vect1);
        Vector3f U = this.position.subtract(E, vars.vect2);
        Vector3f D = otherCenter.subtract(U, vars.vect3);
        float dSquared = D.dot(D);
        float e = this.direction.dot(D);
        if (e > 0.0f && e * e >= dSquared * this.outerAngleCosSqr) {
            D = otherCenter.subtract(this.position, vars.vect3);
            dSquared = D.dot(D);
            e = -this.direction.dot(D);
            if (e > 0.0f && e * e >= dSquared * this.outerAngleSinSqr) {
                return dSquared <= otherRadiusSquared;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsSphere(BoundingSphere sphere, TempVars vars) {
        if (this.spotRange > 0.0f && !Intersection.intersect(sphere, this.position, this.spotRange)) {
            return false;
        }
        float otherRadiusSquared = FastMath.sqr(sphere.getRadius());
        float otherRadius = sphere.getRadius();
        Vector3f E = this.direction.mult(otherRadius * this.outerAngleSinRcp, vars.vect1);
        Vector3f U = this.position.subtract(E, vars.vect2);
        Vector3f D = sphere.getCenter().subtract(U, vars.vect3);
        float dSquared = D.dot(D);
        float e = this.direction.dot(D);
        if (e > 0.0f && e * e >= dSquared * this.outerAngleCosSqr) {
            D = sphere.getCenter().subtract(this.position, vars.vect3);
            dSquared = D.dot(D);
            e = -this.direction.dot(D);
            if (e > 0.0f && e * e >= dSquared * this.outerAngleSinSqr) {
                return dSquared <= otherRadiusSquared;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsFrustum(Camera cam, TempVars vars) {
        if (this.spotRange == 0.0f) {
            return true;
        }
        Vector3f farPoint = vars.vect1.set(this.position).addLocal(vars.vect2.set(this.direction).multLocal(this.spotRange));
        for (int i = 5; i >= 0; --i) {
            Plane plane = cam.getWorldPlane(i);
            float dot = plane.pseudoDistance(this.position);
            if (!(dot < 0.0f) || !((dot = plane.pseudoDistance(farPoint)) < 0.0f)) continue;
            float farRadius = this.spotRange / this.outerAngleCos * this.outerAngleSin;
            Vector3f perpDirection = vars.vect2.set(this.direction).crossLocal(plane.getNormal()).normalizeLocal().crossLocal(this.direction);
            Vector3f projectedPoint = vars.vect3.set(farPoint).addLocal(perpDirection.multLocal(farRadius));
            dot = plane.pseudoDistance(projectedPoint);
            if (!(dot < 0.0f)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void computeLastDistance(Spatial owner) {
        if (owner.getWorldBound() != null) {
            BoundingVolume bv = owner.getWorldBound();
            this.lastDistance = bv.distanceSquaredTo(this.position);
        } else {
            this.lastDistance = owner.getWorldTranslation().distanceSquared(this.position);
        }
    }

    @Override
    public Light.Type getType() {
        return Light.Type.Spot;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public final void setDirection(Vector3f direction) {
        this.direction.set(direction);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public final void setPosition(Vector3f position) {
        this.position.set(position);
    }

    public float getSpotRange() {
        return this.spotRange;
    }

    public void setSpotRange(float spotRange) {
        if (spotRange < 0.0f) {
            throw new IllegalArgumentException("SpotLight range cannot be negative");
        }
        this.spotRange = spotRange;
        this.invSpotRange = spotRange != 0.0f ? 1.0f / spotRange : 0.0f;
    }

    public float getInvSpotRange() {
        return this.invSpotRange;
    }

    public float getSpotInnerAngle() {
        return this.spotInnerAngle;
    }

    public void setSpotInnerAngle(float spotInnerAngle) {
        if (spotInnerAngle < 0.0f || spotInnerAngle >= 1.5707964f) {
            throw new IllegalArgumentException("spot angle must be between 0 and pi/2");
        }
        this.spotInnerAngle = spotInnerAngle;
        this.computeAngleParameters();
    }

    public float getSpotOuterAngle() {
        return this.spotOuterAngle;
    }

    public void setSpotOuterAngle(float spotOuterAngle) {
        if (spotOuterAngle < 0.0f || spotOuterAngle >= 1.5707964f) {
            throw new IllegalArgumentException("spot angle must be between 0 and pi/2");
        }
        this.spotOuterAngle = spotOuterAngle;
        this.computeAngleParameters();
    }

    public float getPackedAngleCos() {
        return this.packedAngleCos;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.direction, "direction", new Vector3f());
        oc.write(this.position, "position", new Vector3f());
        oc.write(this.spotInnerAngle, "spotInnerAngle", 0.09817477f);
        oc.write(this.spotOuterAngle, "spotOuterAngle", 0.1308997f);
        oc.write(this.spotRange, "spotRange", 100.0f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.spotInnerAngle = ic.readFloat("spotInnerAngle", 0.09817477f);
        this.spotOuterAngle = ic.readFloat("spotOuterAngle", 0.1308997f);
        this.computeAngleParameters();
        this.direction = (Vector3f)ic.readSavable("direction", new Vector3f());
        this.position = (Vector3f)ic.readSavable("position", new Vector3f());
        this.spotRange = ic.readFloat("spotRange", 100.0f);
        this.invSpotRange = this.spotRange != 0.0f ? 1.0f / this.spotRange : 0.0f;
    }

    @Override
    public SpotLight clone() {
        SpotLight s = (SpotLight)super.clone();
        s.direction = this.direction.clone();
        s.position = this.position.clone();
        return s;
    }
}

