uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraPosition;

layout(location = 0) in vec3 inPosition;
layout(location = 1) in vec3 inNormal;

out vec3 refVec;

void main(){
    gl_Position = g_WorldViewProjectionMatrix * vec4(inPosition, 1.0);

    vec4 worldPos4 = g_WorldMatrix * vec4(inPosition, 1.0);
    vec3 worldPos = worldPos4.xyz;
    vec4 inNormal4 = vec4(inNormal, 0.0); // Changed to 0.0 for the w component of the normal
    vec4 norm4 = g_WorldMatrix * inNormal4;
    vec3 norm = norm4.xyz;
   
    vec3 I = normalize(worldPos - g_CameraPosition);
    vec3 N = normalize(norm) * -1.0;

    refVec = -1.0 * reflect(I, N);
}
