/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.JmeSystem;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScreenshotAppState
extends AbstractAppState
implements ActionListener,
SceneProcessor {
    private static final Logger logger = Logger.getLogger(ScreenshotAppState.class.getName());
    private String filePath = null;
    private boolean capture = false;
    private boolean numbered = true;
    private Renderer renderer;
    private RenderManager rm;
    private ByteBuffer outBuf;
    private String shotName;
    private long shotIndex = 0L;
    private int width;
    private int height;
    private InputManager inputManager;
    private ViewPort last;

    public ScreenshotAppState() {
        this(null);
    }

    public ScreenshotAppState(String filePath) {
        this.filePath = filePath;
    }

    public ScreenshotAppState(String filePath, String fileName) {
        this.filePath = filePath;
        this.shotName = fileName;
    }

    public ScreenshotAppState(String filePath, long shotIndex) {
        this.filePath = filePath;
        this.shotIndex = shotIndex;
    }

    public ScreenshotAppState(String filePath, String fileName, long shotIndex) {
        this.filePath = filePath;
        this.shotName = fileName;
        this.shotIndex = shotIndex;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFileName(String fileName) {
        this.shotName = fileName;
    }

    public void setShotIndex(long index) {
        this.shotIndex = index;
    }

    public void setIsNumbered(boolean numberedWanted) {
        this.numbered = numberedWanted;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        if (!super.isInitialized()) {
            this.inputManager = app.getInputManager();
            this.inputManager.addMapping("ScreenShot", new KeyTrigger(183));
            this.inputManager.addListener(this, "ScreenShot");
            List<ViewPort> vps = app.getRenderManager().getPostViews();
            this.last = vps.get(vps.size() - 1);
            this.last.addProcessor(this);
            if (this.shotName == null) {
                this.shotName = app.getClass().getSimpleName();
            }
        }
        super.initialize(stateManager, app);
    }

    @Override
    public void cleanup() {
        ViewPort viewPort;
        if (this.inputManager != null) {
            this.inputManager.deleteMapping("ScreenShot");
            this.inputManager.removeListener(this);
            this.inputManager = null;
        }
        if ((viewPort = this.last) != null) {
            this.last = null;
            viewPort.removeProcessor(this);
        }
        super.cleanup();
    }

    @Override
    public void onAction(String name, boolean value, float tpf) {
        if (value) {
            this.capture = true;
        }
    }

    public void takeScreenshot() {
        this.capture = true;
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderer = rm.getRenderer();
        this.rm = rm;
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
    }

    @Override
    public boolean isInitialized() {
        return super.isInitialized() && this.renderer != null;
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
        this.outBuf = BufferUtils.createByteBuffer(w * h * 4);
        this.width = w;
        this.height = h;
    }

    @Override
    public void preFrame(float tpf) {
    }

    @Override
    public void postQueue(RenderQueue rq) {
    }

    @Override
    public void postFrame(FrameBuffer out) {
        if (this.capture) {
            String filename;
            this.capture = false;
            Camera curCamera = this.rm.getCurrentCamera();
            int viewX = (int)(curCamera.getViewPortLeft() * (float)curCamera.getWidth());
            int viewY = (int)(curCamera.getViewPortBottom() * (float)curCamera.getHeight());
            int viewWidth = (int)((curCamera.getViewPortRight() - curCamera.getViewPortLeft()) * (float)curCamera.getWidth());
            int viewHeight = (int)((curCamera.getViewPortTop() - curCamera.getViewPortBottom()) * (float)curCamera.getHeight());
            this.renderer.setViewPort(0, 0, this.width, this.height);
            this.renderer.readFrameBuffer(out, this.outBuf);
            this.renderer.setViewPort(viewX, viewY, viewWidth, viewHeight);
            if (this.numbered) {
                ++this.shotIndex;
                filename = this.shotName + this.shotIndex;
            } else {
                filename = this.shotName;
            }
            File file = this.filePath == null ? new File(JmeSystem.getStorageFolder() + File.separator + filename + ".png").getAbsoluteFile() : new File(this.filePath + filename + ".png").getAbsoluteFile();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Saving ScreenShot to: {0}", file.getAbsolutePath());
            }
            try {
                this.writeImageFile(file);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error while saving screenshot", ex);
            }
        }
    }

    @Override
    public void setProfiler(AppProfiler profiler) {
    }

    protected void writeImageFile(File file) throws IOException {
        try (FileOutputStream outStream = new FileOutputStream(file);){
            JmeSystem.writeImageFile(outStream, "png", this.outBuf, this.width, this.height);
        }
    }
}

