/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.cache;

import com.jme3.asset.AssetKey;
import com.jme3.asset.cache.AssetCache;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeakRefAssetCache
implements AssetCache {
    private static final Logger logger = Logger.getLogger(WeakRefAssetCache.class.getName());
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final ConcurrentHashMap<AssetKey, AssetRef> assetCache = new ConcurrentHashMap();

    private void removeCollectedAssets() {
        AssetRef ref;
        int removedAssets = 0;
        while ((ref = (AssetRef)this.refQueue.poll()) != null) {
            if (this.assetCache.remove(ref.assetKey) == null) continue;
            ++removedAssets;
        }
        if (removedAssets >= 1) {
            logger.log(Level.FINE, "WeakRefAssetCache: {0} assets were purged from the cache.", removedAssets);
        }
    }

    @Override
    public <T> void addToCache(AssetKey<T> key, T obj) {
        this.removeCollectedAssets();
        AssetRef ref = new AssetRef(key, obj, this.refQueue);
        this.assetCache.put(key, ref);
    }

    @Override
    public <T> T getFromCache(AssetKey<T> key) {
        AssetRef ref = this.assetCache.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    @Override
    public boolean deleteFromCache(AssetKey key) {
        return this.assetCache.remove(key) != null;
    }

    @Override
    public void clearCache() {
        this.assetCache.clear();
    }

    @Override
    public <T> void registerAssetClone(AssetKey<T> key, T clone) {
    }

    @Override
    public void notifyNoAssetClone() {
    }

    private static class AssetRef
    extends WeakReference<Object> {
        private final AssetKey assetKey;

        public AssetRef(AssetKey assetKey, Object originalAsset, ReferenceQueue<Object> refQueue) {
            super(originalAsset, refQueue);
            this.assetKey = assetKey;
        }
    }
}

