/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.tween.action.Action;
import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnimEvent
extends AbstractCinematicEvent {
    public static final Logger logger = Logger.getLogger(AnimEvent.class.getName());
    private AnimComposer composer;
    private Cinematic cinematic;
    private String actionName;
    private String layerName;

    public AnimEvent(AnimComposer composer, String actionName, String layerName) {
        this.composer = composer;
        this.actionName = actionName;
        this.layerName = layerName;
        Action eventAction = composer.action(actionName);
        this.initialDuration = (float)eventAction.getLength();
    }

    protected AnimEvent() {
    }

    @Override
    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        this.cinematic = cinematic;
    }

    @Override
    public void onPause() {
        Object layerManager;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "layer={0} action={1}", new Object[]{this.layerName, this.actionName});
        }
        if ((layerManager = this.composer.getLayerManager(this.layerName)) == this) {
            Action eventAction = this.composer.action(this.actionName);
            eventAction.setSpeed(0.0);
        }
    }

    @Override
    public void onPlay() {
        Action eventAction;
        Action currentAction;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "layer={0} action={1}", new Object[]{this.layerName, this.actionName});
        }
        if ((currentAction = this.composer.getCurrentAction(this.layerName)) != (eventAction = this.composer.action(this.actionName))) {
            this.composer.setCurrentAction(this.actionName, this.layerName);
            assert (this.composer.getCurrentAction(this.layerName) == eventAction);
        }
        if (this.playState == PlayState.Stopped) {
            this.composer.setTime(this.layerName, 0.0);
        }
        eventAction.setSpeed(this.speed);
        this.composer.setLayerManager(this.layerName, this);
    }

    @Override
    public void onStop() {
        Object layerManager;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "layer={0} action={1}", new Object[]{this.layerName, this.actionName});
        }
        if ((layerManager = this.composer.getLayerManager(this.layerName)) == this) {
            this.composer.removeCurrentAction(this.layerName);
            this.composer.setLayerManager(this.layerName, null);
        }
    }

    @Override
    public void onUpdate(float tpf) {
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.actionName = capsule.readString("actionName", "");
        this.cinematic = (Cinematic)capsule.readSavable("cinematic", null);
        this.composer = (AnimComposer)capsule.readSavable("composer", null);
        this.layerName = capsule.readString("layerName", "Default");
    }

    @Override
    public void setSpeed(float speed) {
        logger.log(Level.INFO, "speed = {0}", Float.valueOf(speed));
        super.setSpeed(speed);
        if (this.playState != PlayState.Stopped) {
            Action eventAction = this.composer.action(this.actionName);
            eventAction.setSpeed(speed);
        }
    }

    @Override
    public void setTime(float time) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "layer={0} action={1} time={2}", new Object[]{this.layerName, this.actionName, Float.valueOf(time)});
        }
        super.setTime(time);
        Action currentAction = this.composer.getCurrentAction(this.layerName);
        Action eventAction = this.composer.action(this.actionName);
        if (currentAction != eventAction) {
            this.composer.setCurrentAction(this.actionName, this.layerName);
            assert (this.composer.getCurrentAction(this.layerName) == eventAction);
        }
        float t = time;
        float duration = (float)eventAction.getLength();
        if (this.loopMode == LoopMode.Loop) {
            t %= duration;
        } else if (this.loopMode == LoopMode.Cycle) {
            float direction = (float)Math.ceil(time / duration);
            t = direction > 0.0f && direction % 2.0f == 0.0f ? duration - t % duration : (t %= duration);
        }
        if (t < 0.0f) {
            this.composer.setTime(this.layerName, 0.0);
        } else if (t > duration) {
            this.composer.setTime(this.layerName, t);
            this.stop();
        } else {
            this.composer.setTime(this.layerName, t);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule(this);
        capsule.write(this.actionName, "actionName", "");
        capsule.write(this.cinematic, "cinematic", null);
        capsule.write(this.composer, "composer", null);
        capsule.write(this.layerName, "layerName", "Default");
    }
}

