/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.Light;
import com.jme3.scene.Spatial;
import com.jme3.util.SortUtil;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LightList
implements Iterable<Light>,
Savable,
Cloneable,
JmeCloneable {
    private Light[] list;
    private Light[] tlist;
    private float[] distToOwner;
    private int listSize;
    private Spatial owner;
    private static final int DEFAULT_SIZE = 1;
    private static final Comparator<Light> c = new Comparator<Light>(){

        @Override
        public int compare(Light l1, Light l2) {
            if (l1.lastDistance < l2.lastDistance) {
                return -1;
            }
            if (l1.lastDistance > l2.lastDistance) {
                return 1;
            }
            return 0;
        }
    };

    protected LightList() {
    }

    public LightList(Spatial owner) {
        this.listSize = 0;
        this.list = new Light[1];
        this.distToOwner = new float[1];
        Arrays.fill(this.distToOwner, Float.NEGATIVE_INFINITY);
        this.owner = owner;
    }

    public void setOwner(Spatial owner) {
        this.owner = owner;
    }

    private void doubleSize() {
        Light[] temp = new Light[this.list.length * 2];
        float[] temp2 = new float[this.list.length * 2];
        System.arraycopy(this.list, 0, temp, 0, this.list.length);
        System.arraycopy(this.distToOwner, 0, temp2, 0, this.list.length);
        this.list = temp;
        this.distToOwner = temp2;
    }

    public void add(Light l) {
        if (this.listSize == this.list.length) {
            this.doubleSize();
        }
        this.list[this.listSize] = l;
        this.distToOwner[this.listSize++] = Float.NEGATIVE_INFINITY;
    }

    public void remove(int index) {
        if (index >= this.listSize || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.listSize;
        if (index == this.listSize) {
            this.list[this.listSize] = null;
            return;
        }
        for (int i = index; i < this.listSize; ++i) {
            this.list[i] = this.list[i + 1];
        }
        this.list[this.listSize] = null;
    }

    public void remove(Light l) {
        for (int i = 0; i < this.listSize; ++i) {
            if (this.list[i] != l) continue;
            this.remove(i);
            return;
        }
    }

    public int size() {
        return this.listSize;
    }

    public Light get(int num) {
        if (num >= this.listSize || num < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.list[num];
    }

    public void clear() {
        if (this.listSize == 0) {
            return;
        }
        for (int i = 0; i < this.listSize; ++i) {
            this.list[i] = null;
        }
        if (this.tlist != null) {
            Arrays.fill(this.tlist, null);
        }
        this.listSize = 0;
    }

    public void sort(boolean transformChanged) {
        if (this.listSize > 1) {
            if (this.tlist == null || this.tlist.length != this.list.length) {
                this.tlist = (Light[])this.list.clone();
            } else {
                System.arraycopy(this.list, 0, this.tlist, 0, this.list.length);
            }
            if (transformChanged) {
                for (int i = 0; i < this.listSize; ++i) {
                    this.list[i].computeLastDistance(this.owner);
                }
            }
            SortUtil.msort(this.tlist, this.list, 0, this.listSize - 1, c);
        }
    }

    public void update(LightList local, LightList parent) {
        this.clear();
        while (this.list.length <= local.listSize) {
            this.doubleSize();
        }
        System.arraycopy(local.list, 0, this.list, 0, local.listSize);
        for (int i = 0; i < local.listSize; ++i) {
            this.distToOwner[i] = Float.NEGATIVE_INFINITY;
        }
        if (parent != null) {
            int sz = local.listSize + parent.listSize;
            while (this.list.length <= sz) {
                this.doubleSize();
            }
            for (int i = 0; i < parent.listSize; ++i) {
                int p = i + local.listSize;
                this.list[p] = parent.list[i];
                this.distToOwner[p] = Float.NEGATIVE_INFINITY;
            }
            this.listSize = local.listSize + parent.listSize;
        } else {
            this.listSize = local.listSize;
        }
    }

    @Override
    public Iterator<Light> iterator() {
        return new Iterator<Light>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < LightList.this.size();
            }

            @Override
            public Light next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LightList.this.list[this.index++];
            }

            @Override
            public void remove() {
                LightList.this.remove(--this.index);
            }
        };
    }

    public LightList clone() {
        try {
            LightList clone = (LightList)super.clone();
            clone.owner = null;
            clone.list = (Light[])this.list.clone();
            clone.distToOwner = (float[])this.distToOwner.clone();
            clone.tlist = null;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public LightList jmeClone() {
        try {
            LightList clone = (LightList)super.clone();
            clone.tlist = null;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.owner = cloner.clone(this.owner);
        this.list = cloner.clone(this.list);
        this.distToOwner = cloner.clone(this.distToOwner);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        ArrayList<Light> lights = new ArrayList<Light>();
        for (int i = 0; i < this.listSize; ++i) {
            lights.add(this.list[i]);
        }
        oc.writeSavableArrayList(lights, "lights", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        ArrayList lights = ic.readSavableArrayList("lights", null);
        this.listSize = lights.size();
        int arraySize = Math.max(1, this.listSize);
        this.list = new Light[arraySize];
        this.distToOwner = new float[arraySize];
        for (int i = 0; i < this.listSize; ++i) {
            this.list[i] = (Light)lights.get(i);
        }
        Arrays.fill(this.distToOwner, Float.NEGATIVE_INFINITY);
    }
}

