/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.ShaderNodeDefinitionKey;
import com.jme3.material.plugins.MatParseException;
import com.jme3.material.plugins.ShaderNodeLoaderDelegate;
import com.jme3.util.blockparser.BlockLanguageParser;
import com.jme3.util.blockparser.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ShaderNodeDefinitionLoader
implements AssetLoader {
    private ShaderNodeLoaderDelegate loaderDelegate;

    @Override
    public Object load(AssetInfo assetInfo) throws IOException {
        AssetKey k = assetInfo.getKey();
        if (!(k instanceof ShaderNodeDefinitionKey)) {
            throw new IOException("ShaderNodeDefinition file must be loaded via ShaderNodeDefinitionKey");
        }
        ShaderNodeDefinitionKey key = (ShaderNodeDefinitionKey)k;
        this.loaderDelegate = new ShaderNodeLoaderDelegate();
        InputStream in = assetInfo.openStream();
        List<Statement> roots = BlockLanguageParser.parse(in);
        if (roots.size() == 2) {
            Statement exception = roots.get(0);
            String line = exception.getLine();
            if (line.startsWith("Exception")) {
                throw new AssetLoadException(line.substring("Exception ".length()));
            }
            throw new MatParseException("In multi-root shader node definition, expected first statement to be 'Exception'", exception);
        }
        if (roots.size() != 1) {
            throw new MatParseException("Too many roots in J3SN file", roots.get(0));
        }
        return this.loaderDelegate.readNodesDefinitions(roots.get(0).getContents(), key);
    }
}

