/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.io.Serializable;

public final class Ring
implements Savable,
Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private Vector3f center;
    private Vector3f up;
    private float innerRadius;
    private float outerRadius;
    private static transient Vector3f b1 = new Vector3f();
    private static transient Vector3f b2 = new Vector3f();

    public Ring() {
        this.center = new Vector3f();
        this.up = Vector3f.UNIT_Y.clone();
        this.innerRadius = 0.0f;
        this.outerRadius = 1.0f;
    }

    public Ring(Vector3f center, Vector3f up, float innerRadius, float outerRadius) {
        this.center = center;
        this.up = up;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public void setCenter(Vector3f center) {
        this.center = center;
    }

    public Vector3f getUp() {
        return this.up;
    }

    public void setUp(Vector3f up) {
        this.up = up;
    }

    public float getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(float innerRadius) {
        this.innerRadius = innerRadius;
    }

    public float getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(float outerRadius) {
        this.outerRadius = outerRadius;
    }

    public Vector3f random() {
        return this.random(null);
    }

    public Vector3f random(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        float inner2 = this.innerRadius * this.innerRadius;
        float outer2 = this.outerRadius * this.outerRadius;
        float r = FastMath.sqrt(inner2 + FastMath.nextRandomFloat() * (outer2 - inner2));
        float theta = FastMath.nextRandomFloat() * ((float)Math.PI * 2);
        this.up.cross(Vector3f.UNIT_X, b1);
        if (b1.lengthSquared() < 1.1920929E-7f) {
            this.up.cross(Vector3f.UNIT_Y, b1);
        }
        b1.normalizeLocal();
        this.up.cross(b1, b2);
        result.set(b1).multLocal(r * FastMath.cos(theta)).addLocal(this.center);
        result.scaleAdd(r * FastMath.sin(theta), b2, result);
        return result;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.center, "center", Vector3f.ZERO);
        capsule.write(this.up, "up", Vector3f.UNIT_Z);
        capsule.write(this.innerRadius, "innerRadius", 0.0f);
        capsule.write(this.outerRadius, "outerRadius", 1.0f);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule(this);
        this.center = (Vector3f)capsule.readSavable("center", Vector3f.ZERO.clone());
        this.up = (Vector3f)capsule.readSavable("up", Vector3f.UNIT_Z.clone());
        this.innerRadius = capsule.readFloat("innerRadius", 0.0f);
        this.outerRadius = capsule.readFloat("outerRadius", 1.0f);
    }

    public Ring clone() {
        try {
            Ring r = (Ring)super.clone();
            r.center = this.center.clone();
            r.up = this.up.clone();
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

