/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.control;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public class LightControl
extends AbstractControl {
    private static final String CONTROL_DIR_NAME = "controlDir";
    private static final String LIGHT_NAME = "light";
    private Light light;
    private ControlDirection controlDir = ControlDirection.SpatialToLight;

    public LightControl() {
    }

    public LightControl(Light light) {
        this.light = light;
    }

    public LightControl(Light light, ControlDirection controlDir) {
        this.light = light;
        this.controlDir = controlDir;
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public ControlDirection getControlDir() {
        return this.controlDir;
    }

    public void setControlDir(ControlDirection controlDir) {
        this.controlDir = controlDir;
    }

    @Override
    protected void controlUpdate(float tpf) {
        if (this.spatial != null && this.light != null) {
            switch (this.controlDir) {
                case SpatialToLight: {
                    this.spatialToLight(this.light);
                    break;
                }
                case LightToSpatial: {
                    this.lightToSpatial(this.light);
                }
            }
        }
    }

    private void spatialToLight(Light light) {
        TempVars vars = TempVars.get();
        Vector3f worldTranslation = vars.vect1;
        worldTranslation.set(this.spatial.getWorldTranslation());
        Vector3f worldDirection = vars.vect2;
        this.spatial.getWorldRotation().mult(Vector3f.UNIT_Z, worldDirection).negateLocal();
        if (light instanceof PointLight) {
            ((PointLight)light).setPosition(worldTranslation);
        } else if (light instanceof DirectionalLight) {
            ((DirectionalLight)light).setDirection(worldDirection);
        } else if (light instanceof SpotLight) {
            SpotLight spotLight = (SpotLight)light;
            spotLight.setPosition(worldTranslation);
            spotLight.setDirection(worldDirection);
        }
        vars.release();
    }

    private void lightToSpatial(Light light) {
        TempVars vars = TempVars.get();
        Vector3f translation = vars.vect1;
        Vector3f direction = vars.vect2;
        Quaternion rotation = vars.quat1;
        boolean rotateSpatial = false;
        boolean translateSpatial = false;
        if (light instanceof PointLight) {
            PointLight pLight = (PointLight)light;
            translation.set(pLight.getPosition());
            translateSpatial = true;
        } else if (light instanceof DirectionalLight) {
            DirectionalLight dLight = (DirectionalLight)light;
            direction.set(dLight.getDirection()).negateLocal();
            rotateSpatial = true;
        } else if (light instanceof SpotLight) {
            SpotLight sLight = (SpotLight)light;
            translation.set(sLight.getPosition());
            direction.set(sLight.getDirection()).negateLocal();
            rotateSpatial = true;
            translateSpatial = true;
        }
        if (this.spatial.getParent() != null) {
            this.spatial.getParent().getLocalToWorldMatrix(vars.tempMat4).invertLocal();
            vars.tempMat4.rotateVect(translation);
            vars.tempMat4.translateVect(translation);
            vars.tempMat4.rotateVect(direction);
        }
        if (rotateSpatial) {
            rotation.lookAt(direction, Vector3f.UNIT_Y).normalizeLocal();
            this.spatial.setLocalRotation(rotation);
        }
        if (translateSpatial) {
            this.spatial.setLocalTranslation(translation);
        }
        vars.release();
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.light = cloner.clone(this.light);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.controlDir = ic.readEnum(CONTROL_DIR_NAME, ControlDirection.class, ControlDirection.SpatialToLight);
        this.light = (Light)ic.readSavable(LIGHT_NAME, null);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.controlDir, CONTROL_DIR_NAME, ControlDirection.SpatialToLight);
        oc.write(this.light, LIGHT_NAME, null);
    }

    public static enum ControlDirection {
        LightToSpatial,
        SpatialToLight;

    }
}

