/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;

public class SkeletonWire
extends Mesh {
    private int numConnections;
    private Skeleton skeleton;
    private Map<Integer, Float> boneLengths;

    public SkeletonWire(Skeleton skeleton) {
        this(skeleton, null);
    }

    public SkeletonWire(Skeleton skeleton, Map<Integer, Float> boneLengths) {
        this.skeleton = skeleton;
        for (Bone bone : skeleton.getRoots()) {
            this.countConnections(bone);
        }
        this.setMode(Mesh.Mode.Lines);
        int lineVerticesCount = skeleton.getBoneCount();
        if (boneLengths != null) {
            this.boneLengths = boneLengths;
            lineVerticesCount *= 2;
        }
        VertexBuffer pb = new VertexBuffer(VertexBuffer.Type.Position);
        FloatBuffer fpb = BufferUtils.createFloatBuffer(lineVerticesCount * 3);
        pb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, fpb);
        this.setBuffer(pb);
        VertexBuffer ib = new VertexBuffer(VertexBuffer.Type.Index);
        ShortBuffer sib = BufferUtils.createShortBuffer(boneLengths != null ? lineVerticesCount : this.numConnections * 2);
        ib.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.UnsignedShort, sib);
        this.setBuffer(ib);
        if (boneLengths != null) {
            for (int i = 0; i < lineVerticesCount; ++i) {
                sib.put((short)i);
            }
        } else {
            for (Bone bone : skeleton.getRoots()) {
                this.writeConnections(sib, bone);
            }
        }
        sib.flip();
        this.updateCounts();
    }

    protected SkeletonWire() {
    }

    public void updateGeometry() {
        VertexBuffer vb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer posBuf = this.getFloatBuffer(VertexBuffer.Type.Position);
        posBuf.clear();
        for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
            Bone bone = this.skeleton.getBone(i);
            Vector3f head = bone.getModelSpacePosition();
            posBuf.put(head.getX()).put(head.getY()).put(head.getZ());
            if (this.boneLengths == null) continue;
            Vector3f tail = head.add(bone.getModelSpaceRotation().mult(Vector3f.UNIT_Y.mult(this.boneLengths.get(i).floatValue())));
            posBuf.put(tail.getX()).put(tail.getY()).put(tail.getZ());
        }
        posBuf.flip();
        vb.updateData(posBuf);
        this.updateBound();
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.numConnections = capsule.readInt("numConnections", 1);
        this.skeleton = (Skeleton)capsule.readSavable("skeleton", null);
        int[] blKeys = capsule.readIntArray("blKeys", null);
        float[] blValues = capsule.readFloatArray("blValues", null);
        if (blKeys == null) {
            this.boneLengths = null;
        } else {
            assert (blValues.length == blKeys.length);
            int numLengths = blKeys.length;
            this.boneLengths = new HashMap<Integer, Float>(numLengths);
            for (int i = 0; i < numLengths; ++i) {
                this.boneLengths.put(blKeys[i], Float.valueOf(blValues[i]));
            }
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule(this);
        capsule.write(this.numConnections, "numConnections", 1);
        capsule.write(this.skeleton, "skeleton", null);
        if (this.boneLengths != null) {
            int numLengths = this.boneLengths.size();
            int[] blKeys = new int[numLengths];
            float[] blValues = new float[numLengths];
            int i = 0;
            for (Map.Entry<Integer, Float> entry : this.boneLengths.entrySet()) {
                blKeys[i] = entry.getKey();
                blValues[i] = entry.getValue().floatValue();
                ++i;
            }
            capsule.write(blKeys, "blKeys", (int[])null);
            capsule.write(blValues, "blValues", (float[])null);
        }
    }

    private void countConnections(Bone bone) {
        for (Bone child : bone.getChildren()) {
            ++this.numConnections;
            this.countConnections(child);
        }
    }

    private void writeConnections(ShortBuffer indexBuf, Bone bone) {
        for (Bone child : bone.getChildren()) {
            indexBuf.put((short)this.skeleton.getBoneIndex(bone));
            indexBuf.put((short)this.skeleton.getBoneIndex(child));
            this.writeConnections(indexBuf, child);
        }
    }
}

