/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.mesh;

import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class IndexByteBuffer
extends IndexBuffer {
    private final ByteBuffer buf;
    private int maxValue = 255;

    public IndexByteBuffer(ByteBuffer buffer) {
        this.buf = buffer;
        this.buf.rewind();
    }

    public IndexByteBuffer(ByteBuffer buffer, int maxValue) {
        assert (maxValue >= 0 && maxValue <= 255) : "out of range: " + maxValue;
        this.maxValue = maxValue;
        this.buf = buffer;
        this.buf.rewind();
    }

    @Override
    public int get() {
        return this.buf.get() & 0xFF;
    }

    @Override
    public int get(int i) {
        return this.buf.get(i) & 0xFF;
    }

    @Override
    public IndexByteBuffer put(int i, int value) {
        assert (value >= 0 && value <= this.maxValue) : "IndexBuffer was created with elements too small for value=" + value;
        this.buf.put(i, (byte)value);
        return this;
    }

    @Override
    public IndexByteBuffer put(int value) {
        assert (value >= 0 && value <= this.maxValue) : "IndexBuffer was created with elements too small for value=" + value;
        this.buf.put((byte)value);
        return this;
    }

    @Override
    public int size() {
        return this.buf.limit();
    }

    @Override
    public Buffer getBuffer() {
        return this.buf;
    }

    @Override
    public VertexBuffer.Format getFormat() {
        return VertexBuffer.Format.UnsignedByte;
    }
}

