/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.ModelKey;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.scene.mesh.IndexIntBuffer;
import com.jme3.scene.mesh.IndexShortBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OBJLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(OBJLoader.class.getName());
    protected final ArrayList<Vector3f> verts = new ArrayList();
    protected final ArrayList<Vector2f> texCoords = new ArrayList();
    protected final ArrayList<Vector3f> norms = new ArrayList();
    private final ArrayList<Group> groups = new ArrayList();
    protected String currentMatName;
    protected String currentObjectName;
    protected final HashMap<Vertex, Integer> vertIndexMap = new HashMap(100);
    protected final IntMap<Vertex> indexVertMap = new IntMap(100);
    protected int curIndex = 0;
    protected int objectIndex = 0;
    protected int geomIndex = 0;
    protected Scanner scan;
    protected ModelKey key;
    protected AssetManager assetManager;
    protected MaterialList matList;
    protected String objName;
    protected Node objNode;
    private final ArrayList<Vertex> vertList = new ArrayList();

    public void reset() {
        this.verts.clear();
        this.texCoords.clear();
        this.norms.clear();
        this.groups.clear();
        this.vertIndexMap.clear();
        this.indexVertMap.clear();
        this.currentMatName = null;
        this.matList = null;
        this.curIndex = 0;
        this.geomIndex = 0;
        this.scan = null;
    }

    protected void findVertexIndex(Vertex vert) {
        Integer index = this.vertIndexMap.get(vert);
        if (index != null) {
            vert.index = index;
        } else {
            vert.index = this.curIndex++;
            this.vertIndexMap.put(vert, vert.index);
            this.indexVertMap.put(vert.index, vert);
        }
    }

    protected Face[] quadToTriangle(Face f) {
        float d2;
        assert (f.verticies.length == 4);
        Face[] t = new Face[]{new Face(), new Face()};
        t[0].verticies = new Vertex[3];
        t[1].verticies = new Vertex[3];
        Vertex v0 = f.verticies[0];
        Vertex v1 = f.verticies[1];
        Vertex v2 = f.verticies[2];
        Vertex v3 = f.verticies[3];
        float d1 = v0.v.distanceSquared(v2.v);
        if (d1 < (d2 = v1.v.distanceSquared(v3.v))) {
            t[0].verticies[0] = v0;
            t[0].verticies[1] = v1;
            t[0].verticies[2] = v3;
            t[1].verticies[0] = v1;
            t[1].verticies[1] = v2;
            t[1].verticies[2] = v3;
        } else {
            t[0].verticies[0] = v0;
            t[0].verticies[1] = v1;
            t[0].verticies[2] = v2;
            t[1].verticies[0] = v0;
            t[1].verticies[1] = v2;
            t[1].verticies[2] = v3;
        }
        return t;
    }

    protected void readFace() {
        String[] verticies;
        Face f = new Face();
        this.vertList.clear();
        String line = this.scan.nextLine().trim();
        for (String vertex : verticies = line.split("\\s+")) {
            int v = 0;
            int vt = 0;
            int vn = 0;
            String[] split = vertex.split("/");
            if (split.length == 1) {
                v = Integer.parseInt(split[0].trim());
            } else if (split.length == 2) {
                v = Integer.parseInt(split[0].trim());
                vt = Integer.parseInt(split[1].trim());
            } else if (split.length == 3 && !split[1].equals("")) {
                v = Integer.parseInt(split[0].trim());
                vt = Integer.parseInt(split[1].trim());
                vn = Integer.parseInt(split[2].trim());
            } else if (split.length == 3) {
                v = Integer.parseInt(split[0].trim());
                vn = Integer.parseInt(split[2].trim());
            }
            if (v < 0) {
                v = this.verts.size() + v + 1;
            }
            if (vt < 0) {
                vt = this.texCoords.size() + vt + 1;
            }
            if (vn < 0) {
                vn = this.norms.size() + vn + 1;
            }
            Vertex vx = new Vertex();
            vx.v = this.verts.get(v - 1);
            if (vt > 0) {
                vx.vt = this.texCoords.get(vt - 1);
            }
            if (vn > 0) {
                vx.vn = this.norms.get(vn - 1);
            }
            this.vertList.add(vx);
        }
        if (this.vertList.size() > 4 || this.vertList.size() <= 2) {
            logger.warning("Edge or polygon detected in OBJ. Ignored.");
            return;
        }
        f.verticies = new Vertex[this.vertList.size()];
        for (int i = 0; i < this.vertList.size(); ++i) {
            f.verticies[i] = this.vertList.get(i);
        }
        Group group = this.groups.get(this.groups.size() - 1);
        if (this.currentMatName != null && this.matList != null && this.matList.containsKey(this.currentMatName)) {
            ArrayList<Face> matFaces = (ArrayList<Face>)group.matFaces.get(this.currentMatName);
            if (matFaces == null) {
                matFaces = new ArrayList<Face>();
                group.matFaces.put(this.currentMatName, matFaces);
            }
            matFaces.add(f);
        } else {
            group.faces.add(f);
        }
    }

    protected Vector3f readVector3() {
        Vector3f v = new Vector3f();
        v.set(Float.parseFloat(this.scan.next()), Float.parseFloat(this.scan.next()), Float.parseFloat(this.scan.next()));
        return v;
    }

    protected Vector2f readVector2() {
        Vector2f v = new Vector2f();
        String line = this.scan.nextLine().trim();
        String[] split = line.split("\\s+");
        v.setX(Float.parseFloat(split[0].trim()));
        v.setY(Float.parseFloat(split[1].trim()));
        return v;
    }

    protected void loadMtlLib(String name) throws IOException {
        if (!name.toLowerCase().endsWith(".mtl")) {
            throw new IOException("Expected .mtl file! Got: " + name);
        }
        name = new File(name).getName();
        AssetKey mtlKey = new AssetKey(this.key.getFolder() + name);
        try {
            this.matList = (MaterialList)this.assetManager.loadAsset(mtlKey);
        }
        catch (AssetNotFoundException ex) {
            logger.log(Level.WARNING, "Cannot locate {0} for model {1}", new Object[]{name, this.key});
        }
    }

    protected boolean nextStatement() {
        try {
            this.scan.skip(".*\r{0,1}\n");
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    protected boolean readLine() throws IOException {
        if (!this.scan.hasNext()) {
            return false;
        }
        String cmd = this.scan.next();
        if (cmd.startsWith("#")) {
            return this.nextStatement();
        }
        if (cmd.equals("v")) {
            this.verts.add(this.readVector3());
        } else if (cmd.equals("vn")) {
            this.norms.add(this.readVector3());
        } else if (cmd.equals("vt")) {
            this.texCoords.add(this.readVector2());
        } else if (cmd.equals("f")) {
            this.readFace();
        } else if (cmd.equals("usemtl")) {
            this.currentMatName = this.scan.next();
        } else if (cmd.equals("mtllib")) {
            String mtllib = this.scan.nextLine().trim();
            this.loadMtlLib(mtllib);
        } else {
            if (cmd.equals("s")) {
                logger.log(Level.WARNING, "smoothing groups are not supported, statement ignored: {0}", cmd);
                return this.nextStatement();
            }
            if (cmd.equals("mg")) {
                logger.log(Level.WARNING, "merge groups are not supported, statement ignored: {0}", cmd);
                return this.nextStatement();
            }
            if (cmd.equals("g")) {
                this.groups.add(new Group(this.scan.nextLine().trim()));
            } else {
                logger.log(Level.WARNING, "Unknown statement in OBJ! {0}", cmd);
                return this.nextStatement();
            }
        }
        return true;
    }

    protected Geometry createGeometry(ArrayList<Face> faceList, String matName) throws IOException {
        if (faceList.isEmpty()) {
            throw new IOException("No geometry data to generate mesh");
        }
        Mesh mesh = this.constructMesh(faceList);
        Geometry geom = new Geometry(this.objName + "-geom-" + this.geomIndex++, mesh);
        Material material = null;
        if (matName != null && this.matList != null) {
            material = (Material)this.matList.get(matName);
        }
        if (material == null) {
            material = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
            material.setFloat("Shininess", 64.0f);
        }
        geom.setMaterial(material);
        if (material.isTransparent()) {
            geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        } else {
            geom.setQueueBucket(RenderQueue.Bucket.Opaque);
        }
        if (material.getMaterialDef().getName().contains("Lighting") && mesh.getFloatBuffer(VertexBuffer.Type.Normal) == null) {
            logger.log(Level.WARNING, "OBJ mesh {0} doesn't contain normals! It might not display correctly", geom.getName());
        }
        return geom;
    }

    protected Mesh constructMesh(ArrayList<Face> faceList) {
        Mesh m = new Mesh();
        m.setMode(Mesh.Mode.Triangles);
        boolean hasTexCoord = false;
        boolean hasNormals = false;
        ArrayList<Face> newFaces = new ArrayList<Face>(faceList.size());
        for (int i = 0; i < faceList.size(); ++i) {
            Face f = faceList.get(i);
            for (Vertex v : f.verticies) {
                this.findVertexIndex(v);
                if (!hasTexCoord && v.vt != null) {
                    hasTexCoord = true;
                }
                if (hasNormals || v.vn == null) continue;
                hasNormals = true;
            }
            if (f.verticies.length == 4) {
                Face[] t = this.quadToTriangle(f);
                newFaces.add(t[0]);
                newFaces.add(t[1]);
                continue;
            }
            newFaces.add(f);
        }
        FloatBuffer posBuf = BufferUtils.createFloatBuffer(this.vertIndexMap.size() * 3);
        FloatBuffer normBuf = null;
        FloatBuffer tcBuf = null;
        if (hasNormals) {
            normBuf = BufferUtils.createFloatBuffer(this.vertIndexMap.size() * 3);
            m.setBuffer(VertexBuffer.Type.Normal, 3, normBuf);
        }
        if (hasTexCoord) {
            tcBuf = BufferUtils.createFloatBuffer(this.vertIndexMap.size() * 2);
            m.setBuffer(VertexBuffer.Type.TexCoord, 2, tcBuf);
        }
        IndexBuffer indexBuf = null;
        if (this.vertIndexMap.size() >= 65536) {
            IntBuffer ib = BufferUtils.createIntBuffer(newFaces.size() * 3);
            m.setBuffer(VertexBuffer.Type.Index, 3, ib);
            indexBuf = new IndexIntBuffer(ib);
        } else {
            ShortBuffer sb = BufferUtils.createShortBuffer(newFaces.size() * 3);
            m.setBuffer(VertexBuffer.Type.Index, 3, sb);
            indexBuf = new IndexShortBuffer(sb);
        }
        int numFaces = newFaces.size();
        for (int i = 0; i < numFaces; ++i) {
            Face f = (Face)newFaces.get(i);
            if (f.verticies.length != 3) continue;
            Vertex v0 = f.verticies[0];
            Vertex v1 = f.verticies[1];
            Vertex v2 = f.verticies[2];
            posBuf.position(v0.index * 3);
            posBuf.put(v0.v.x).put(v0.v.y).put(v0.v.z);
            posBuf.position(v1.index * 3);
            posBuf.put(v1.v.x).put(v1.v.y).put(v1.v.z);
            posBuf.position(v2.index * 3);
            posBuf.put(v2.v.x).put(v2.v.y).put(v2.v.z);
            if (normBuf != null && v0.vn != null) {
                normBuf.position(v0.index * 3);
                normBuf.put(v0.vn.x).put(v0.vn.y).put(v0.vn.z);
                normBuf.position(v1.index * 3);
                normBuf.put(v1.vn.x).put(v1.vn.y).put(v1.vn.z);
                normBuf.position(v2.index * 3);
                normBuf.put(v2.vn.x).put(v2.vn.y).put(v2.vn.z);
            }
            if (tcBuf != null && v0.vt != null) {
                tcBuf.position(v0.index * 2);
                tcBuf.put(v0.vt.x).put(v0.vt.y);
                tcBuf.position(v1.index * 2);
                tcBuf.put(v1.vt.x).put(v1.vt.y);
                tcBuf.position(v2.index * 2);
                tcBuf.put(v2.vt.x).put(v2.vt.y);
            }
            int index = i * 3;
            indexBuf.put(index, v0.index);
            indexBuf.put(index + 1, v1.index);
            indexBuf.put(index + 2, v2.index);
        }
        m.setBuffer(VertexBuffer.Type.Position, 3, posBuf);
        m.setStatic();
        m.updateBound();
        m.updateCounts();
        this.vertIndexMap.clear();
        this.indexVertMap.clear();
        this.curIndex = 0;
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info) throws IOException {
        this.reset();
        this.key = (ModelKey)info.getKey();
        this.assetManager = info.getManager();
        this.objName = this.key.getName();
        String folderName = this.key.getFolder();
        String ext = this.key.getExtension();
        this.objName = this.objName.substring(0, this.objName.length() - ext.length() - 1);
        if (folderName != null && folderName.length() > 0) {
            this.objName = this.objName.substring(folderName.length());
        }
        this.objNode = new Node(this.objName + "-objnode");
        Group defaultGroupStub = new Group(null);
        this.groups.add(defaultGroupStub);
        if (!(info.getKey() instanceof ModelKey)) {
            throw new IllegalArgumentException("Model assets must be loaded using a ModelKey");
        }
        try (InputStream in = null;){
            in = info.openStream();
            this.scan = new Scanner(in);
            this.scan.useLocale(Locale.US);
            while (this.readLine()) {
            }
        }
        for (Group group : this.groups) {
            if (group == defaultGroupStub) {
                this.materializeGroup(group, this.objNode);
                continue;
            }
            Node groupNode = new Node(group.name);
            this.materializeGroup(group, groupNode);
            if (groupNode.getQuantity() == 1) {
                Spatial geom = groupNode.getChild(0);
                geom.setName(groupNode.getName());
                this.objNode.attachChild(geom);
                continue;
            }
            if (groupNode.getQuantity() <= 1) continue;
            this.objNode.attachChild(groupNode);
        }
        if (this.objNode.getQuantity() == 1) {
            return this.objNode.getChild(0);
        }
        return this.objNode;
    }

    private void materializeGroup(Group group, Node container) throws IOException {
        if (group.matFaces.size() > 0) {
            for (Map.Entry entry : group.matFaces.entrySet()) {
                ArrayList materialFaces = (ArrayList)entry.getValue();
                if (materialFaces.size() <= 0) continue;
                Geometry geom = this.createGeometry(materialFaces, (String)entry.getKey());
                container.attachChild(geom);
            }
        } else if (group.faces.size() > 0) {
            Geometry geom = this.createGeometry(group.faces, null);
            container.attachChild(geom);
        }
    }

    protected static class Vertex {
        Vector3f v;
        Vector2f vt;
        Vector3f vn;
        int index;

        protected Vertex() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Vertex other = (Vertex)obj;
            if (!(this.v == other.v || this.v != null && this.v.equals(other.v))) {
                return false;
            }
            if (!(this.vt == other.vt || this.vt != null && this.vt.equals(other.vt))) {
                return false;
            }
            return this.vn == other.vn || this.vn != null && this.vn.equals(other.vn);
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (this.v != null ? this.v.hashCode() : 0);
            hash = 53 * hash + (this.vt != null ? this.vt.hashCode() : 0);
            hash = 53 * hash + (this.vn != null ? this.vn.hashCode() : 0);
            return hash;
        }
    }

    protected static class Face {
        Vertex[] verticies;

        protected Face() {
        }
    }

    private static class Group {
        private final String name;
        private final ArrayList<Face> faces = new ArrayList();
        private final HashMap<String, ArrayList<Face>> matFaces = new HashMap();

        public Group(String name) {
            this.name = name;
        }
    }

    protected class ObjectGroup {
        final String objectName;

        public ObjectGroup(String objectName) {
            this.objectName = objectName;
        }

        public Spatial createGeometry() {
            Node groupNode = new Node(this.objectName);
            if (this.objectName == null) {
                groupNode.setName("Model");
            }
            return groupNode;
        }
    }
}

