/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.math.Spline;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.util.Iterator;
import java.util.List;

public class Curve
extends Mesh {
    private Spline spline;
    private Vector3f temp = new Vector3f();

    protected Curve() {
    }

    public Curve(Vector3f[] controlPoints, int nbSubSegments) {
        this(new Spline(Spline.SplineType.CatmullRom, controlPoints, 10.0f, false), nbSubSegments);
    }

    public Curve(Spline spline, int nbSubSegments) {
        this.spline = spline;
        switch (spline.getType()) {
            case CatmullRom: {
                this.createCatmullRomMesh(nbSubSegments);
                break;
            }
            case Bezier: {
                this.createBezierMesh(nbSubSegments);
                break;
            }
            case Nurb: {
                this.createNurbMesh(nbSubSegments);
                break;
            }
            default: {
                this.createLinearMesh();
            }
        }
    }

    private void createCatmullRomMesh(int nbSubSegments) {
        float[] array = new float[((this.spline.getControlPoints().size() - 1) * nbSubSegments + 1) * 3];
        short[] indices = new short[(this.spline.getControlPoints().size() - 1) * nbSubSegments * 2];
        int i = 0;
        int cptCP = 0;
        Iterator<Vector3f> it = this.spline.getControlPoints().iterator();
        while (it.hasNext()) {
            Vector3f vector3f = it.next();
            array[i] = vector3f.x;
            array[++i] = vector3f.y;
            array[++i] = vector3f.z;
            ++i;
            if (it.hasNext()) {
                for (int j = 1; j < nbSubSegments; ++j) {
                    this.spline.interpolate((float)j / (float)nbSubSegments, cptCP, this.temp);
                    array[i] = this.temp.getX();
                    array[++i] = this.temp.getY();
                    array[++i] = this.temp.getZ();
                    ++i;
                }
            }
            ++cptCP;
        }
        i = 0;
        for (int j = 0; j < (this.spline.getControlPoints().size() - 1) * nbSubSegments; ++j) {
            int k = j;
            indices[i] = (short)k;
            indices[++i] = (short)(++k);
            ++i;
        }
        this.setMode(Mesh.Mode.Lines);
        this.setBuffer(VertexBuffer.Type.Position, 3, array);
        this.setBuffer(VertexBuffer.Type.Index, 2, indices);
        this.updateBound();
        this.updateCounts();
    }

    private void createBezierMesh(int nbSubSegments) {
        if (nbSubSegments == 0) {
            nbSubSegments = 1;
        }
        int centerPointsAmount = (this.spline.getControlPoints().size() + 2) / 3;
        float[] array = new float[((centerPointsAmount - 1) * nbSubSegments + 1) * 3];
        int currentControlPoint = 0;
        List<Vector3f> controlPoints = this.spline.getControlPoints();
        int lineIndex = 0;
        for (int i = 0; i < centerPointsAmount - 1; ++i) {
            Vector3f vector3f = controlPoints.get(currentControlPoint);
            array[lineIndex++] = vector3f.x;
            array[lineIndex++] = vector3f.y;
            array[lineIndex++] = vector3f.z;
            for (int j = 1; j < nbSubSegments; ++j) {
                this.spline.interpolate((float)j / (float)nbSubSegments, currentControlPoint, this.temp);
                array[lineIndex++] = this.temp.getX();
                array[lineIndex++] = this.temp.getY();
                array[lineIndex++] = this.temp.getZ();
            }
            currentControlPoint += 3;
        }
        Vector3f vector3f = controlPoints.get(currentControlPoint);
        array[lineIndex++] = vector3f.x;
        array[lineIndex++] = vector3f.y;
        array[lineIndex++] = vector3f.z;
        int i = 0;
        short[] indices = new short[(centerPointsAmount - 1) * nbSubSegments << 1];
        for (int j = 0; j < (centerPointsAmount - 1) * nbSubSegments; ++j) {
            int k = j;
            indices[i++] = (short)k;
            indices[i++] = (short)(++k);
        }
        this.setMode(Mesh.Mode.Lines);
        this.setBuffer(VertexBuffer.Type.Position, 3, array);
        this.setBuffer(VertexBuffer.Type.Index, 2, indices);
        this.updateBound();
        this.updateCounts();
    }

    private void createNurbMesh(int nbSubSegments) {
        if (this.spline.getControlPoints() != null && this.spline.getControlPoints().size() > 0) {
            int i;
            nbSubSegments = nbSubSegments == 0 ? this.spline.getControlPoints().size() + 1 : this.spline.getControlPoints().size() * nbSubSegments + 1;
            float minKnot = this.spline.getMinNurbKnot();
            float maxKnot = this.spline.getMaxNurbKnot();
            float deltaU = (maxKnot - minKnot) / (float)nbSubSegments;
            float[] array = new float[(nbSubSegments + 1) * 3];
            float u = minKnot;
            Vector3f interpolationResult = new Vector3f();
            for (i = 0; i < array.length; i += 3) {
                this.spline.interpolate(u, 0, interpolationResult);
                array[i] = interpolationResult.x;
                array[i + 1] = interpolationResult.y;
                array[i + 2] = interpolationResult.z;
                u += deltaU;
            }
            i = 0;
            short[] indices = new short[nbSubSegments << 1];
            for (int j = 0; j < nbSubSegments; ++j) {
                indices[i++] = (short)j;
                indices[i++] = (short)(j + 1);
            }
            this.setMode(Mesh.Mode.Lines);
            this.setBuffer(VertexBuffer.Type.Position, 3, array);
            this.setBuffer(VertexBuffer.Type.Index, 2, indices);
            this.updateBound();
            this.updateCounts();
        }
    }

    private void createLinearMesh() {
        float[] array = new float[this.spline.getControlPoints().size() * 3];
        short[] indices = new short[(this.spline.getControlPoints().size() - 1) * 2];
        int i = 0;
        int cpt = 0;
        int j = 0;
        Iterator<Vector3f> it = this.spline.getControlPoints().iterator();
        while (it.hasNext()) {
            Vector3f vector3f = it.next();
            array[i] = vector3f.getX();
            array[++i] = vector3f.getY();
            array[++i] = vector3f.getZ();
            ++i;
            if (!it.hasNext()) continue;
            int k = j;
            indices[cpt] = (short)k;
            indices[++cpt] = (short)(++k);
            ++cpt;
            ++j;
        }
        this.setMode(Mesh.Mode.Lines);
        this.setBuffer(VertexBuffer.Type.Position, 3, array);
        this.setBuffer(VertexBuffer.Type.Index, 2, indices);
        this.updateBound();
        this.updateCounts();
    }

    public float getLength() {
        return this.spline.getTotalLength();
    }
}

