/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.shader.VariableMapping;

public class ShaderUtils {
    private ShaderUtils() {
    }

    public static String convertToGLSL130(String input, boolean isFrag) {
        StringBuilder sb = new StringBuilder();
        sb.append("#version 130\n");
        if (isFrag) {
            input = input.replaceAll("varying", "in");
        } else {
            input = input.replaceAll("attribute", "in");
            input = input.replaceAll("varying", "out");
        }
        sb.append(input);
        return sb.toString();
    }

    public static boolean typesMatch(VariableMapping mapping) {
        String leftType = mapping.getLeftVariable().getType();
        String rightType = mapping.getRightVariable().getType();
        String leftSwizzling = mapping.getLeftSwizzling();
        String rightSwizzling = mapping.getRightSwizzling();
        if (leftType.equals(rightType) && leftSwizzling.length() == rightSwizzling.length()) {
            return true;
        }
        return ShaderUtils.isSwizzlable(leftType) && ShaderUtils.isSwizzlable(rightType) && ShaderUtils.getCardinality(leftType, leftSwizzling) == ShaderUtils.getCardinality(rightType, rightSwizzling);
    }

    public static boolean multiplicityMatch(VariableMapping mapping) {
        String leftMult = mapping.getLeftVariable().getMultiplicity();
        String rightMult = mapping.getRightVariable().getMultiplicity();
        if (leftMult == null) {
            if (rightMult != null) {
                return false;
            }
        } else {
            if (rightMult == null) {
                return false;
            }
            if (!leftMult.equalsIgnoreCase(rightMult)) {
                return false;
            }
        }
        return true;
    }

    public static int getCardinality(String type, String swizzling) {
        int card = 0;
        if (ShaderUtils.isSwizzlable(type)) {
            if (type.equals("float")) {
                card = 1;
                if (swizzling.length() != 0) {
                    card = 0;
                }
            } else {
                card = Integer.parseInt(type.replaceAll(".*vec", ""));
                if (swizzling.length() > 0) {
                    card = swizzling.length();
                }
            }
        }
        return card;
    }

    public static boolean isSwizzlable(String type) {
        return type.indexOf("vec4") > -1 || type.indexOf("vec3") > -1 || type.indexOf("vec2") > -1 || type.equals("float");
    }
}

