/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.clone;

import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.CloneFunction;
import com.jme3.util.clone.JmeCloneable;
import com.jme3.util.clone.ListCloneFunction;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cloner {
    private static final Logger log = Logger.getLogger(Cloner.class.getName());
    private final IdentityHashMap<Object, Object> index = new IdentityHashMap();
    private final Map<Class, CloneFunction> functions = new HashMap<Class, CloneFunction>();
    private static final Map<Class, Method> methodCache = new ConcurrentHashMap<Class, Method>();

    public Cloner() {
        ListCloneFunction listFunction = new ListCloneFunction();
        this.functions.put(ArrayList.class, listFunction);
        this.functions.put(LinkedList.class, listFunction);
        this.functions.put(CopyOnWriteArrayList.class, listFunction);
        this.functions.put(Vector.class, listFunction);
        this.functions.put(Stack.class, listFunction);
        this.functions.put(SafeArrayList.class, listFunction);
    }

    public static <T> T deepClone(T object) {
        return new Cloner().clone(object);
    }

    public <T> T clone(T object) {
        return this.clone(object, true);
    }

    private <T> Class<T> objectClass(T object) {
        return object.getClass();
    }

    public <T> T clone(T object, boolean useFunctions) {
        if (object == null) {
            return null;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("cloning:" + object.getClass() + "@" + System.identityHashCode(object));
        }
        Class<T> type = this.objectClass(object);
        Object clone = this.index.get(object);
        if (clone != null || this.index.containsKey(object)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("cloned:" + object.getClass() + "@" + System.identityHashCode(object) + " as cached:" + (clone == null ? "null" : clone.getClass() + "@" + System.identityHashCode(clone)));
            }
            return type.cast(clone);
        }
        CloneFunction<T> f = this.getCloneFunction(type);
        if (f != null) {
            T result = f.cloneObject(this, object);
            this.index.put(object, result);
            f.cloneFields(this, result, object);
            if (log.isLoggable(Level.FINER)) {
                if (result == null) {
                    log.finer("cloned:" + object.getClass() + "@" + System.identityHashCode(object) + " as transformed:null");
                } else {
                    log.finer("clone:" + object.getClass() + "@" + System.identityHashCode(object) + " as transformed:" + result.getClass() + "@" + System.identityHashCode(result));
                }
            }
            return result;
        }
        if (object.getClass().isArray()) {
            clone = this.arrayClone(object);
        } else if (object instanceof JmeCloneable) {
            clone = ((JmeCloneable)object).jmeClone();
            this.index.put(object, clone);
            ((JmeCloneable)clone).cloneFields(this, object);
        } else if (object instanceof Cloneable) {
            try {
                clone = this.javaClone(object);
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException("Object is not cloneable, type:" + type, e);
            }
            this.index.put(object, clone);
        } else {
            throw new IllegalArgumentException("Object is not cloneable, type:" + type);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("cloned:" + object.getClass() + "@" + System.identityHashCode(object) + " as " + clone.getClass() + "@" + System.identityHashCode(clone));
        }
        return type.cast(clone);
    }

    public <T> void setCloneFunction(Class<T> type, CloneFunction<T> function) {
        if (function == null) {
            this.functions.remove(type);
        } else {
            this.functions.put(type, function);
        }
    }

    public <T> CloneFunction<T> getCloneFunction(Class<T> type) {
        CloneFunction result = this.functions.get(type);
        if (result == null) {
            for (Map.Entry<Class, CloneFunction> e : this.functions.entrySet()) {
                if (!e.getKey().isAssignableFrom(type)) continue;
                result = e.getValue();
                break;
            }
            if (result != null) {
                this.functions.put(type, result);
            }
        }
        return result;
    }

    public <T> void setClonedValue(T original, T clone) {
        this.index.put(original, clone);
    }

    public boolean isCloned(Object o) {
        return this.index.containsKey(o);
    }

    public void clearIndex() {
        this.index.clear();
    }

    public <T> T javaClone(T object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        Method m = methodCache.get(object.getClass());
        if (m == null) {
            try {
                m = object.getClass().getMethod("clone", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new CloneNotSupportedException("No public clone method found for:" + object.getClass());
            }
            methodCache.put(object.getClass(), m);
        }
        try {
            Class<T> type = this.objectClass(object);
            return type.cast(m.invoke(object, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error cloning object of type:" + object.getClass(), e);
        }
    }

    protected <T> T arrayClone(T object) {
        Class<T> type = this.objectClass(object);
        Class<?> elementType = type.getComponentType();
        int size = Array.getLength(object);
        Object clone = Array.newInstance(elementType, size);
        this.index.put(object, clone);
        if (elementType.isPrimitive()) {
            System.arraycopy(object, 0, clone, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                Object element = this.clone(Array.get(object, i));
                Array.set(clone, i, element);
            }
        }
        return type.cast(clone);
    }
}

