/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d;

import java.util.ArrayList;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.assimp.Assimp;

public class AsImpTest {
    private static ArrayList<Float> positions = new ArrayList();
    private static ArrayList<Float> texCoordinates = new ArrayList();
    private static ArrayList<Float> normals = new ArrayList();
    private static ArrayList<Float> colors = new ArrayList();

    public static void main(String[] args) {
    }

    private static void loadFile(String filepath) {
        AIScene scene = Assimp.aiImportFile((CharSequence)filepath, (int)8);
        PointerBuffer buffer = scene.mMeshes();
        for (int i = 0; i < buffer.limit(); ++i) {
            AIMesh mesh = AIMesh.create((long)buffer.get(i));
            AsImpTest.processMesh(mesh);
        }
    }

    private static void processMesh(AIMesh mesh) {
        AIVector3D.Buffer vectors = mesh.mVertices();
        for (int i = 0; i < vectors.limit(); ++i) {
            AIVector3D vec = (AIVector3D)vectors.get(i);
            positions.add(Float.valueOf(vec.x()));
            positions.add(Float.valueOf(vec.y()));
            positions.add(Float.valueOf(vec.z()));
        }
        AIVector3D.Buffer coords = mesh.mTextureCoords(0);
        for (int i = 0; i < coords.limit(); ++i) {
            AIVector3D coord = (AIVector3D)coords.get(i);
            texCoordinates.add(Float.valueOf(coord.x()));
            texCoordinates.add(Float.valueOf(coord.y()));
            texCoordinates.add(Float.valueOf(coord.z()));
        }
        AIVector3D.Buffer norms = mesh.mNormals();
        for (int i = 0; i < coords.limit(); ++i) {
            AIVector3D n = (AIVector3D)norms.get(i);
            normals.add(Float.valueOf(n.x()));
            normals.add(Float.valueOf(n.y()));
            normals.add(Float.valueOf(n.z()));
        }
        AIColor4D.Buffer vertexColors = mesh.mColors(0);
        for (int i = 0; i < vertexColors.limit(); ++i) {
            AIColor4D vertexColor = (AIColor4D)vertexColors.get(i);
            colors.add(Float.valueOf(vertexColor.r()));
            colors.add(Float.valueOf(vertexColor.g()));
            colors.add(Float.valueOf(vertexColor.b()));
            colors.add(Float.valueOf(vertexColor.a()));
        }
    }
}

