/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.applicationcontrol;

import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlClientConnectionListener;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlServer;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSessionMessageProcessor;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSessionSetupMessage;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationController;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.transport.MessageTransportConnection;
import com.hybridlab.hyve3d.satellitecenter.SessionID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationControlSession
implements ApplicationControlClientConnectionListener {
    private final Logger logger = Logger.getLogger(ApplicationControlSession.class.getSimpleName());
    private ApplicationController satellite;
    private final ApplicationControlServer applicationControlServer;
    private MessageTransportConnection connection;
    private final SessionID id;
    List<ApplicationControlSessionMessageProcessor> sessionMessageProcessors = new ArrayList<ApplicationControlSessionMessageProcessor>();

    public SessionID getSessionId() {
        return this.id;
    }

    public ApplicationControlSession(ApplicationControlServer applicationControlServer) {
        this.applicationControlServer = applicationControlServer;
        this.id = new SessionID();
    }

    @Override
    public void onConnectionClosed(MessageTransportConnection conn) {
        this.logger.log(Level.INFO, "connection closed !" + conn);
        this.Close();
    }

    public void Close() {
        this.connection = null;
        this.applicationControlServer.onSessionClosed(this);
    }

    @Override
    public void onConnectionLost(MessageTransportConnection conn) {
        this.logger.log(Level.WARNING, "connection lost !" + conn);
        this.connection = null;
        this.applicationControlServer.onSessionLost(this);
    }

    @Override
    public void onConnectionEstablished(MessageTransportConnection conn) {
        this.connection = conn;
        this.logger.log(Level.INFO, "connection established !");
        try {
            ApplicationControlSessionSetupMessage setup = new ApplicationControlSessionSetupMessage();
            this.connection.send(setup);
        }
        catch (MessageTransportConnection.SendFailedException e) {
            try {
                this.connection.disconnect();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public void registerMessageProcessor(ApplicationControlSessionMessageProcessor p) {
        this.sessionMessageProcessors.add(p);
    }

    @Override
    @Deprecated
    public void onAbstractMessageReceived(AbstractHisMessage message) {
        this.logger.log(Level.INFO, "onMessageReceived: " + message.toString());
        for (ApplicationControlSessionMessageProcessor proc : this.sessionMessageProcessors) {
            proc.processMessage(this, message);
        }
    }

    @Override
    public void onMessageReceived(ApplicationControlSessionSetupMessage message) {
        this.logger.log(Level.INFO, "onMessageReceived: " + message.toString());
    }

    public void sendMessage(AbstractHisMessage message) {
        try {
            this.connection.send(message);
        }
        catch (NullPointerException e) {
            this.logger.log(Level.SEVERE, "Message couldnt not be sent: " + message.toString(), e);
        }
        catch (MessageTransportConnection.SendFailedException e) {
            this.logger.log(Level.SEVERE, "Message couldnt not be sent: " + message.toString(), e);
        }
    }
}

