/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.applicationcontrol;

import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlServer;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSession;
import com.hybridlab.hyve3d.applicationcontrol.SpiderMonkeyApplicationControlConnection;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.satellitecenter.SatelliteServer;
import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Network;
import com.jme3.network.Server;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class FAB8BasedApplicationControlServer
implements SatelliteServer.SatelliteClientServerMessageChannel {
    private Logger logger = Logger.getLogger(FAB8BasedApplicationControlServer.class.getName());
    private Server spiderMonkeyServer;
    private NetworkServiceManager networkServiceManager;
    private ApplicationControlServer satelliteServer;
    private List<SpiderMonkeyApplicationControlConnection> connections = new ArrayList<SpiderMonkeyApplicationControlConnection>();

    public FAB8BasedApplicationControlServer(ApplicationControlServer satteliteServer, NetworkServiceManager networkServiceManager) {
        this.networkServiceManager = networkServiceManager;
        this.satelliteServer = satteliteServer;
    }

    @Override
    public void stop() {
        for (HostedConnection conn : this.spiderMonkeyServer.getConnections()) {
            conn.close("shutdown");
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.spiderMonkeyServer.close();
    }

    @Override
    public void start() {
        try {
            int port = ApplicationControlServer.defaultPort;
            this.logger.info(String.format("Start %s at port %d", FAB8BasedApplicationControlServer.class.getSimpleName(), port));
            this.spiderMonkeyServer = Network.createServer((int)port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.spiderMonkeyServer.addConnectionListener(new ConnectionListener(){

            public void connectionRemoved(Server server, HostedConnection conn) {
            }

            public void connectionAdded(Server server, HostedConnection conn) {
                ApplicationControlSession satSession = FAB8BasedApplicationControlServer.this.satelliteServer.createSession();
                SpiderMonkeyApplicationControlConnection connection = new SpiderMonkeyApplicationControlConnection(server, conn, satSession);
                FAB8BasedApplicationControlServer.this.connections.add(connection);
            }
        });
        this.spiderMonkeyServer.start();
    }
}

