/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.applicationcontrol;

import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.transport.spidermonkey.SpiderMonkeyConnection;
import com.hybridlab.hyve3d.satellitecenter.SatelliteServer;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSession;
import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Network;
import com.jme3.network.Server;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Hyve3DApplicationControlServer
implements SatelliteServer.SatelliteClientServerMessageChannel {
    private Logger logger = Logger.getLogger(Hyve3DApplicationControlServer.class.getName());
    private Server spiderMonkeyServer;
    private NetworkServiceManager networkServiceManager;
    private SatelliteServer satelliteServer;
    private List<SpiderMonkeyConnection> connections = new ArrayList<SpiderMonkeyConnection>();

    public Hyve3DApplicationControlServer(SatelliteServer satteliteServer, NetworkServiceManager networkServiceManager) {
        this.networkServiceManager = networkServiceManager;
        this.satelliteServer = satteliteServer;
    }

    @Override
    public void stop() {
        for (HostedConnection conn : this.spiderMonkeyServer.getConnections()) {
            conn.close("shutdown");
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.spiderMonkeyServer.close();
    }

    @Override
    public void start() {
        try {
            int port = this.networkServiceManager.registerService("HyveApplicationControl_SPIDERMONKEY");
            this.logger.info(String.format("Start %s at port %d", Hyve3DApplicationControlServer.class.getSimpleName(), port));
            this.spiderMonkeyServer = Network.createServer((int)port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.spiderMonkeyServer.addConnectionListener(new ConnectionListener(){

            public void connectionRemoved(Server server, HostedConnection conn) {
            }

            public void connectionAdded(Server server, HostedConnection conn) {
                SatelliteSession satSession = Hyve3DApplicationControlServer.this.satelliteServer.createSession();
                SpiderMonkeyConnection connection = new SpiderMonkeyConnection(server, conn, satSession);
                Hyve3DApplicationControlServer.this.connections.add(connection);
            }
        });
        this.spiderMonkeyServer.start();
    }
}

