/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class JSonConfiguration {
    private JSONObject root;
    private boolean changed = false;

    public JSONObject getJSonRootObject() {
        return this.root;
    }

    public JSonConfiguration(JSONObject root) {
        this.root = root;
    }

    public static JSONObject readString(String src) {
        try {
            return new JSONObject(src);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    public static JSONObject readFile(File file) {
        try {
            String src = IOUtils.toString((InputStream)new FileInputStream(file), "UTF-8");
            return new JSONObject(src);
        }
        catch (FileNotFoundException e) {
            return new JSONObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new JSONObject();
    }

    public static JSONObject readFile(File file, KeyReplacer k) {
        try {
            String src = IOUtils.toString((InputStream)new FileInputStream(file), "UTF-8");
            src = k.replaceOldKeyToNewKeys(src);
            return new JSONObject(src);
        }
        catch (FileNotFoundException e) {
            return new JSONObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new JSONObject();
    }

    public static JSONObject readString(String src, KeyReplacer k) {
        try {
            src = k.replaceOldKeyToNewKeys(src);
            return new JSONObject(src);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    public static void writeFile(File file, JSONObject json) {
        try {
            IOUtils.write(json.toString(2), (OutputStream)new FileOutputStream(file), "UTF-8");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void putString(String key, String value) {
        try {
            String old;
            if (this.root.has(key) && (old = this.root.getString(key)).equals(value)) {
                return;
            }
            this.root.put(key, (Object)value);
            this.setChanged();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getString(String key, String alternativeIfNotExists) {
        try {
            String s = this.root.getString(key);
            return s;
        }
        catch (JSONException e) {
            this.putString(key, alternativeIfNotExists);
            return alternativeIfNotExists;
        }
    }

    public boolean getBoolean(String key, boolean alternative) {
        try {
            boolean s = this.root.getBoolean(key);
            return s;
        }
        catch (JSONException e) {
            this.putBoolean(key, alternative);
            return alternative;
        }
    }

    public void putBoolean(String key, boolean b) {
        try {
            boolean old;
            if (this.root.has(key) && (old = this.root.getBoolean(key)) == b) {
                return;
            }
            this.root.put(key, b);
            this.setChanged();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getInteger(String key, int defaultValue) {
        try {
            int s = this.root.getInt(key);
            return s;
        }
        catch (JSONException e) {
            this.putInteger(key, defaultValue);
            this.setChanged();
            return defaultValue;
        }
    }

    public void putInteger(String key, int i) {
        try {
            Integer old;
            if (this.root.has(key) && (old = Integer.valueOf(this.root.getInt(key))).equals(i)) {
                return;
            }
            this.root.put(key, i);
            this.setChanged();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setChanged() {
        this.changed = true;
    }

    public boolean hasChanges() {
        return this.changed;
    }

    public void changesGotSaved() {
        this.changed = false;
    }

    public void putJsonObject(JSONObject o, String ... keys) {
        JSONObject target = this.root;
        if (keys.length > 1) {
            target = this.findJSonObject(this.root, keys);
        }
        try {
            target.put(keys[keys.length - 1], (Object)o);
            this.setChanged();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject findJSonObject(JSONObject j, String[] keys) {
        if (keys.length <= 1) return j;
        JSONObject possibleJSON = j.optJSONObject(keys[0]);
        if (possibleJSON != null) return this.findJSonObject(possibleJSON, ArrayUtils.subarray(keys, 1, keys.length));
        JSONObject x = new JSONObject();
        try {
            j.put(keys[0], (Object)x);
            return this.findJSonObject(x, ArrayUtils.subarray(keys, 1, keys.length));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void putJSonObject(String key, JSONObject o) {
        try {
            JSONObject old;
            if (this.root.has(key) && (old = this.root.getJSONObject(key)).equals(o)) {
                return;
            }
            this.root.put(key, (Object)o);
            this.setChanged();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject getJSonObject(String key) {
        try {
            JSONObject s = this.root.getJSONObject(key);
            return s;
        }
        catch (JSONException e) {
            JSONObject o = new JSONObject();
            this.putJSonObject(key, o);
            return o;
        }
    }

    public static interface KeyReplacer {
        public String replaceOldKeyToNewKeys(String var1);
    }
}

