/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.config;

import com.hybridlab.hyve3d.config.ExportToXMLConfiguration;
import com.hybridlab.hyve3d.config.ReflectionHelper;
import com.hybridlab.xmltools.AbstractXMLFile;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLConfiguration
extends AbstractXMLFile {
    public XMLConfiguration(String filename, String rootNodeName) throws ParserConfigurationException, SAXException, IOException {
        super(filename, rootNodeName);
    }

    public XMLConfiguration(String filename) throws ParserConfigurationException, SAXException, IOException {
        super(filename, "his");
    }

    public <T> ArrayList<T> getArrayList(String path, Class<T> classinfo) {
        ArrayList<T> result = null;
        Node node = this.getNode(path, null, false);
        if (null != node) {
            result = new ArrayList<T>();
            NodeList childNodes = node.getChildNodes();
            int length = childNodes.getLength();
            for (int j = 0; j < length; ++j) {
                Node subNode = childNodes.item(j);
                if (subNode.getNodeName().equalsIgnoreCase("#text")) continue;
                try {
                    Object item = classinfo.newInstance();
                    item = this.setPropertiesInObject(item, classinfo, subNode);
                    result.add(item);
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public <T> T getObject(String path, Class<T> classinfo) {
        Object result = null;
        Node node = this.getNode(path, null, false);
        if (null != node) {
            try {
                result = classinfo.newInstance();
                result = this.setPropertiesInObject(result, classinfo, node);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }
        return (T)result;
    }

    public <T> T getObjectOrCreate(String path, Class<T> classinfo) {
        try {
            Object result = classinfo.newInstance();
            Node node = this.getNode(path, null, false);
            if (null != node) {
                result = this.setPropertiesInObject(result, classinfo, node);
            }
            return result;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object parseObjectFromString(String s, Class<?> classinfo) throws Exception {
        return classinfo.getConstructor(String.class).newInstance(s);
    }

    private Object setPropertiesInObject(Object obj, Class<?> classinfo, Node parent) {
        NodeList childNodes = parent.getChildNodes();
        int length = childNodes.getLength();
        if (!parent.hasChildNodes() || parent.getChildNodes().getLength() == 1 && parent.getChildNodes().item(0).getNodeName().equalsIgnoreCase("#text")) {
            try {
                Object propertyValue = this.getAtomicPropertyValue(parent, classinfo);
                return propertyValue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Method[] methods = classinfo.getMethods();
            for (int i = 0; i < length; ++i) {
                Node childNode = childNodes.item(i);
                String propertyName = childNode.getNodeName();
                if (propertyName.equalsIgnoreCase("#text")) continue;
                boolean setterfound = false;
                for (Method method : methods) {
                    if (!method.getName().equals("set" + propertyName) || !XMLConfiguration.isSetter(method)) continue;
                    try {
                        Class<?> typeinfo = method.getParameterTypes()[0];
                        if (ReflectionHelper.isIterable(typeinfo)) {
                            ArrayList list = null;
                            list = (ArrayList)typeinfo.newInstance();
                            Class listElementsClass = (Class)method.getGenericParameterTypes()[0];
                            NodeList subNodes = childNode.getChildNodes();
                            int subNodesLenth = subNodes.getLength();
                            for (int j = 0; j < subNodesLenth; ++j) {
                                Node subNode = subNodes.item(j);
                                if (subNode.getNodeName().equalsIgnoreCase("#text")) continue;
                                Object item = null;
                                item = listElementsClass.newInstance();
                                item = this.setPropertiesInObject(item, listElementsClass, subNode);
                                list.add(item);
                            }
                            method.invoke(obj, list);
                        } else if (!childNode.hasChildNodes() || childNode.getChildNodes().getLength() == 1 && childNode.getChildNodes().item(0).getNodeName().equalsIgnoreCase("#text")) {
                            Object value = this.getAtomicPropertyValue(childNode, typeinfo);
                            method.invoke(obj, value);
                        }
                        setterfound = true;
                        break;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                if (setterfound) continue;
                try {
                    Node subNode;
                    NodeList subNodes;
                    Field field = classinfo.getDeclaredField(propertyName);
                    if (field.getType().isAssignableFrom(Map.class)) {
                        HashMap map = new HashMap();
                        ParameterizedType listType = (ParameterizedType)field.getGenericType();
                        Class valueClass = (Class)listType.getActualTypeArguments()[1];
                        subNodes = childNode.getChildNodes();
                        int subNodesLenth = subNodes.getLength();
                        for (int j = 0; j < subNodesLenth; ++j) {
                            subNode = subNodes.item(j);
                            if (subNode.getNodeName().equalsIgnoreCase("#text")) continue;
                            String key = subNode.getNodeName();
                            Object item = valueClass.newInstance();
                            item = this.setPropertiesInObject(item, valueClass, subNode);
                            map.put(key, item);
                        }
                        field.setAccessible(true);
                        field.set(obj, map);
                        continue;
                    }
                    if (ReflectionHelper.isIterable(field.getType())) {
                        ArrayList list = (ArrayList)field.getType().newInstance();
                        ParameterizedType listType = (ParameterizedType)field.getGenericType();
                        Class listElementsClass = (Class)listType.getActualTypeArguments()[0];
                        subNodes = childNode.getChildNodes();
                        int subNodesLenth = subNodes.getLength();
                        for (int j = 0; j < subNodesLenth; ++j) {
                            subNode = subNodes.item(j);
                            if (subNode.getNodeName().equalsIgnoreCase("#text")) continue;
                            Object item = listElementsClass.newInstance();
                            item = this.setPropertiesInObject(item, listElementsClass, subNode);
                            list.add(item);
                        }
                        field.setAccessible(true);
                        field.set(obj, list);
                        continue;
                    }
                    if (childNode.hasChildNodes() && (childNode.getChildNodes().getLength() != 1 || !childNode.getChildNodes().item(0).getNodeName().equalsIgnoreCase("#text"))) continue;
                    this.parseTextProperty(obj, childNode, field);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return obj;
    }

    private boolean parseTextProperty(Object obj, Node node, Field field) {
        Class<?> protype = field.getType();
        Object value = this.getAtomicPropertyValue(node, protype);
        if (null != value) {
            field.setAccessible(true);
            try {
                field.set(obj, value);
                return true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private Object getAtomicPropertyValue(Node node, Class<?> protype) {
        String value;
        if ((!node.hasChildNodes() || node.getChildNodes().getLength() == 1 && node.getChildNodes().item(0).getNodeName().equalsIgnoreCase("#text")) && null != (value = node.getTextContent())) {
            if (protype == Integer.TYPE) {
                protype = Integer.class;
            } else if (protype == Double.TYPE) {
                protype = Double.class;
            } else if (protype == Float.TYPE) {
                protype = Float.class;
            }
            try {
                return XMLConfiguration.parseObjectFromString(value, protype);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static boolean isGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    private static boolean hasSetter(Method[] methods, Method method) {
        String methodName = method.getName();
        String setMethodName = methodName.replace("get", "set");
        for (Method setmethod : methods) {
            if (!setmethod.getName().equals(setMethodName)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSetter(Method[] methods, String propertyName) {
        String methodName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        methodName = "set" + methodName;
        for (Method setmethod : methods) {
            if (!setmethod.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public boolean setObject(Node node, String path, Object obj) {
        block23: {
            try {
                if (null == node) break block23;
                this.hasChanges = true;
                XMLConfiguration.removeAllChildNodes(node);
                node.setTextContent("");
                Class<?> classinfo = obj.getClass();
                if (obj.getClass().isAssignableFrom(String.class)) {
                    node.setTextContent((String)obj);
                } else if (!(obj instanceof Map)) {
                    if (ReflectionHelper.isIterable(classinfo)) {
                        Iterable list = (Iterable)obj;
                        this.setArray(path, path, node, list);
                    } else {
                        Element element;
                        ExportToXMLConfiguration anno;
                        String fieldname;
                        Method[] methods = classinfo.getMethods();
                        for (Method method : methods) {
                            if (!XMLConfiguration.isGetter(method) || !XMLConfiguration.hasSetter(methods, method)) continue;
                            fieldname = method.getName().replace("get", "");
                            anno = method.getAnnotation(ExportToXMLConfiguration.class);
                            if (null != anno && !anno.value()) continue;
                            String strValue = "";
                            Object value = null;
                            try {
                                value = method.invoke(obj, new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            if (null != value) {
                                Node subnode;
                                if (value instanceof Map) {
                                    element = this.document.createElement(fieldname);
                                    subnode = node.appendChild(element);
                                    Map map = (Map)value;
                                    this.setMap(fieldname, path, subnode, map);
                                    continue;
                                }
                                if (ReflectionHelper.isIterable(method.getReturnType())) {
                                    element = this.document.createElement(fieldname);
                                    subnode = node.appendChild(element);
                                    Iterable list = (Iterable)value;
                                    this.setArray(fieldname, path, subnode, list);
                                    continue;
                                }
                                strValue = method.getReturnType() == Class.class ? value.toString().replaceFirst("class ", "") : value.toString();
                            }
                            element = this.document.createElement(fieldname);
                            element.setTextContent(strValue);
                            node.appendChild(element);
                        }
                        for (AccessibleObject accessibleObject : classinfo.getDeclaredFields()) {
                            try {
                                fieldname = ((Field)accessibleObject).getName();
                                anno = ((Field)accessibleObject).getAnnotation(ExportToXMLConfiguration.class);
                                if (null != anno && !anno.value() || XMLConfiguration.hasSetter(methods, fieldname)) continue;
                                Object value = null;
                                try {
                                    value = ((Field)accessibleObject).get(obj);
                                }
                                catch (IllegalAccessException e) {
                                    continue;
                                }
                                String strValue = "";
                                if (null != value) {
                                    Node subnode;
                                    Class<?> fieldclassinfo = ((Field)accessibleObject).getType();
                                    if (value instanceof Map) {
                                        Element element2 = this.document.createElement(fieldname);
                                        subnode = node.appendChild(element2);
                                        Map map = (Map)value;
                                        this.setMap(fieldname, path, subnode, map);
                                        continue;
                                    }
                                    if (ReflectionHelper.isIterable(fieldclassinfo)) {
                                        Element element2 = this.document.createElement(fieldname);
                                        subnode = node.appendChild(element2);
                                        Iterable list = (Iterable)value;
                                        this.setArray(fieldname, path, subnode, list);
                                        continue;
                                    }
                                    strValue = fieldclassinfo == Class.class ? value.toString().replaceFirst("class ", "") : value.toString();
                                }
                                element = this.document.createElement(fieldname);
                                element.setTextContent(strValue);
                                node.appendChild(element);
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void setMap(String fieldname, String path, Node parent, Map<?, ?> map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            Element newelem = this.document.createElement(key.toString());
            Node listnode = parent.appendChild(newelem);
            this.setObject(listnode, path + "/" + fieldname + "/" + key.toString(), value);
        }
    }

    private void setArray(String fieldname, String path, Node parent, Iterable<Object> list) {
        for (Object sub : list) {
            Element newelem = this.document.createElement("item");
            Node listnode = parent.appendChild(newelem);
            this.setObject(listnode, path + "/" + fieldname + "/item", sub);
        }
    }

    public boolean setObject(String path, Object obj) {
        return this.setObject(path, obj, true);
    }

    public boolean setObject(String path, Object obj, boolean createIfNotExists) {
        this.hasChanges = true;
        Node node = this.getNode(path, null, createIfNotExists);
        if (null != node) {
            return this.setObject(node, path, obj);
        }
        return false;
    }

    public boolean setString(String path, String value, boolean createIfNotExists) {
        Node node = this.getNode(path, value, createIfNotExists);
        if (null != node) {
            node.setTextContent(value);
            this.hasChanges = true;
            return true;
        }
        return false;
    }

    public boolean setNumber(String path, double value, boolean createIfNotExists) {
        return this.setString(path, String.valueOf(value), createIfNotExists);
    }

    public boolean setNumber(String path, float value, boolean createIfNotExists) {
        return this.setString(path, String.valueOf(value), createIfNotExists);
    }

    public String getString(String path, String defaultValue, boolean createIfNotExists) {
        Node node = this.getNode(path, defaultValue, createIfNotExists);
        if (null != node) {
            if (node.hasChildNodes()) {
                return node.getFirstChild().getNodeValue();
            }
            return node.getNodeValue();
        }
        return defaultValue;
    }

    public double getNumber(String path, double defaultValue, boolean createIfNotExists) {
        String v = this.getString(path, String.valueOf(defaultValue), createIfNotExists);
        if (null != v) {
            try {
                return Double.parseDouble(v);
            }
            catch (NumberFormatException fe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public float getNumber(String path, float defaultValue, boolean createIfNotExists) {
        String v = this.getString(path, String.valueOf(defaultValue), createIfNotExists);
        if (null != v) {
            try {
                return Float.parseFloat(v);
            }
            catch (NumberFormatException fe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean getBool(String path, boolean defaultValue, boolean createIfNotExists) {
        String v = this.getString(path, String.valueOf(defaultValue), createIfNotExists);
        if (null != v) {
            try {
                return Boolean.parseBoolean(v);
            }
            catch (NumberFormatException fe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean setBool(String path, boolean value, boolean createIfNotExists) {
        return this.setString(path, String.valueOf(value), createIfNotExists);
    }

    public NodeList getNodes(String path, boolean createIfNotexists) {
        String fullPath = this.rootNodeName + "/" + path;
        NodeList nodeList = null;
        try {
            Object tmp = this.xPath.compile(fullPath).evaluate(this.document, XPathConstants.NODESET);
            if (null != tmp) {
                nodeList = (NodeList)tmp;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return nodeList;
    }
}

