/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.TransformationOptions;
import com.hybridlab.utils.ThreePerpendicularAxes;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.network.serializing.Serializable;
import java.util.HashSet;
import java.util.Set;

@Serializable
public final class DrawingAreaTransformation {
    public static final FrameRect DefaultFrameRect = new FrameRect();
    private transient Set<DrawAreaTransformationValueObserver> valueObservers = new HashSet<DrawAreaTransformationValueObserver>();
    private Vector3f translation = new Vector3f();
    private Quaternion rotation = new Quaternion();
    private FrameRect frame = new FrameRect(DefaultFrameRect);
    private float scaleFactor = 1.0f;
    private transient TransformationOptions filter = new TransformationOptions();
    private Vector3f cameraRigWorldPosition = new Vector3f();
    private Quaternion compassHeadingRotation = new Quaternion();
    private Quaternion camRigRotation = new Quaternion();
    private boolean ignoreCamRigUpdates = false;

    public String toString() {
        return "DrawingAreaTransformation [translation=" + this.translation + ", rotation=" + this.rotation + ", frame=" + this.frame + ", cameraRigWorldPosition=" + this.cameraRigWorldPosition + ", compassHeadingRotation=" + this.compassHeadingRotation + ", camRigRotation=" + this.camRigRotation + ", hashCode()=" + this.hashCode() + "]";
    }

    public void addValueObserver(DrawAreaTransformationValueObserver observer) {
        this.valueObservers.add(observer);
    }

    private void hasChanged() {
        for (DrawAreaTransformationValueObserver obs : this.valueObservers) {
            obs.hasChanged(this);
        }
    }

    public DrawingAreaTransformation() {
        this.translation = new Vector3f(0.0f, 0.0f, 0.0f);
        this.rotation = new Quaternion();
    }

    public Vector3f getCameraRigWorldPosition() {
        return this.cameraRigWorldPosition;
    }

    public void setCameraRigWorldPosition(Vector3f cameraRigWorldPosition) {
        this.cameraRigWorldPosition = cameraRigWorldPosition;
    }

    public Quaternion getCompassHeadingRotation() {
        return this.compassHeadingRotation;
    }

    public void setCompassHeadingRotation(Quaternion compassHeadingRotation) {
        this.compassHeadingRotation = compassHeadingRotation;
    }

    public Quaternion getCamRigRotation() {
        return this.camRigRotation;
    }

    public void setIgnoreCamRigUpdates(boolean b) {
        this.ignoreCamRigUpdates = b;
        if (b) {
            this.camRigRotation = new Quaternion();
        }
    }

    public void setCamRigRotation(Quaternion camRigRotation) {
        if (!this.ignoreCamRigUpdates) {
            this.camRigRotation = camRigRotation;
        }
    }

    public ThreePerpendicularAxes getAxesLocal() {
        Vector3f[] quaternionAxes = new Vector3f[3];
        this.rotation.toAxes(quaternionAxes);
        ThreePerpendicularAxes axes = new ThreePerpendicularAxes();
        axes.X = quaternionAxes[0];
        axes.Y = quaternionAxes[1];
        axes.Z = quaternionAxes[2];
        return axes;
    }

    public ThreePerpendicularAxes getAxes() {
        Vector3f[] quaternionAxes = new Vector3f[3];
        Quaternion rotationWithAllOthersIncluded = this.camRigRotation.mult(this.compassHeadingRotation).mult(this.rotation);
        rotationWithAllOthersIncluded.toAxes(quaternionAxes);
        ThreePerpendicularAxes axes = new ThreePerpendicularAxes();
        axes.X = quaternionAxes[0];
        axes.Y = quaternionAxes[1];
        axes.Z = quaternionAxes[2];
        return axes;
    }

    public FrameRect getFrameRect() {
        return this.frame;
    }

    public void setFrameRect(FrameRect f) {
        if (f.equals(this.frame)) {
            return;
        }
        this.frame = f;
        this.hasChanged();
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vector3f position) {
        if (position.equals((Object)this.translation)) {
            return;
        }
        this.translation = position;
        this.hasChanged();
    }

    public void move(Vector3f moveVector) {
        if (moveVector.equals((Object)Vector3f.ZERO)) {
            return;
        }
        this.translation.addLocal(moveVector);
        this.hasChanged();
    }

    public void move(Vector2f moveVector) {
        Vector2f relmoveFramerect = this.frameRectToScene(moveVector);
        Vector3f relmove3D = new Vector3f(relmoveFramerect.x, relmoveFramerect.y, 0.0f);
        Vector3f relmove3DWorld = this.rotation.mult(relmove3D);
        if (relmove3DWorld.equals((Object)Vector3f.ZERO)) {
            return;
        }
        this.translation.addLocal(relmove3DWorld);
        this.hasChanged();
    }

    public void move(float factor) {
        Vector3f[] axes = new Vector3f[3];
        this.rotation.toAxes(axes);
        Vector3f z = axes[2].normalizeLocal().mult(factor);
        if (z.equals((Object)Vector3f.ZERO)) {
            return;
        }
        this.translation.addLocal(z);
        this.hasChanged();
    }

    private Vector2f frameRectToScene(Vector2f v) {
        return new Vector2f(v.y * this.scaleFactor, -v.x * this.scaleFactor);
    }

    public void setRotation(Quaternion rot) {
        if (rot.equals((Object)this.rotation)) {
            return;
        }
        this.rotation = rot;
        this.hasChanged();
    }

    public Vector3f planeToSpace(Vector2f point2d) {
        return new Vector3f();
    }

    public Vector2f spaceToPlane(Vector3f moveVector) {
        Vector2f plane = new Vector2f();
        return plane;
    }

    public Quaternion getRotation() {
        return this.rotation.clone();
    }

    public TransformationOptions getFilter() {
        return this.filter;
    }

    public void setFilter(TransformationOptions filter) {
        if (filter.equals(this.filter)) {
            return;
        }
        this.filter = filter;
        this.hasChanged();
    }

    public Vector3f applyFilterToMoveVector(Vector3f globalMoveVector, TransformationOptions.TransformationFilter transformFilter) {
        Vector3f filtered;
        switch (transformFilter) {
            case RXYZ_TGXYZ: 
            case TGXYZ: {
                filtered = globalMoveVector;
                break;
            }
            case TGXZ: {
                filtered = globalMoveVector.clone();
                filtered.y = 0.0f;
                break;
            }
            case TXY: {
                ThreePerpendicularAxes axes = this.getAxes();
                Vector3f xAxis = axes.X;
                Vector3f yAxis = axes.Y;
                Vector3f projectedX = globalMoveVector.project(xAxis);
                Vector3f projectedY = globalMoveVector.project(yAxis);
                filtered = projectedX.add(projectedY);
                break;
            }
            case TX: {
                Vector3f projected1;
                ThreePerpendicularAxes axes = this.getAxes();
                Vector3f xAxis2 = axes.X;
                filtered = projected1 = globalMoveVector.project(xAxis2);
                break;
            }
            case TY: {
                Vector3f projected3;
                ThreePerpendicularAxes axes = this.getAxes();
                Vector3f yAxis2 = axes.Y;
                filtered = projected3 = globalMoveVector.project(yAxis2);
                break;
            }
            case TZ: {
                Vector3f projected2;
                ThreePerpendicularAxes axes = this.getAxes();
                Vector3f zAxis = axes.Z;
                filtered = projected2 = globalMoveVector.project(zAxis);
                break;
            }
            default: {
                filtered = new Vector3f();
            }
        }
        return filtered;
    }

    public void setFrom(DrawingAreaTransformation other) {
        this.cameraRigWorldPosition = other.cameraRigWorldPosition.clone();
        this.camRigRotation = other.camRigRotation.clone();
        this.compassHeadingRotation = other.compassHeadingRotation.clone();
        this.filter.transformFilter = other.filter.transformFilter;
        this.frame = other.frame.getCopy();
        this.translation = other.translation;
        this.rotation = other.rotation;
    }

    public DrawingAreaTransformation getCopy() {
        DrawingAreaTransformation copy = new DrawingAreaTransformation();
        copy.cameraRigWorldPosition = this.cameraRigWorldPosition.clone();
        copy.camRigRotation = this.camRigRotation.clone();
        copy.compassHeadingRotation = this.compassHeadingRotation.clone();
        copy.filter.transformFilter = this.filter.transformFilter;
        copy.frame = this.frame.getCopy();
        copy.translation = this.translation;
        copy.rotation = this.rotation;
        return copy;
    }

    public Quaternion getWorldRotation() {
        return this.camRigRotation.mult(this.compassHeadingRotation).mult(this.rotation);
    }

    static {
        DefaultFrameRect.setWidthAndHeight(1.3333334f, 1.0f);
    }

    public static interface DrawAreaTransformationValueObserver {
        public void hasChanged(DrawingAreaTransformation var1);
    }
}

