/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.AbstractBaseScene;
import com.hybridlab.hyve3d.core.DrawingArea;
import com.hybridlab.hyve3d.core.DrawingAreaBookmark;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.HisClientRenderer;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DObserver;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.jme3.Stroke3DSelectionAndTransformationGroup;
import com.hybridlab.hyve3d.files.His3dSceneXMLDocument;
import com.hybridlab.hyve3d.network.interconnection.HisScene;
import com.hybridlab.hyve3d.network.interconnection.HisSceneMemento;
import com.hybridlab.hyve3d.scenes.StaticSceneElementState;
import com.hybridlab.utils.CompressionUtils;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.DataFormatException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.xml.sax.SAXException;

public class His3DScene
extends AbstractBaseScene
implements HisScene,
Stroke3DObserver {
    private His3DCanvas canvas3D;
    private HisClientRenderer renderer;
    private Map<DrawingArea, His3DCanvas> canvasesOfDrawingAreas = new HashMap<DrawingArea, His3DCanvas>();
    private List<His3DCanvas> canvasesWithoutDrawingAreas = new ArrayList<His3DCanvas>();
    private List<DrawingAreaBookmark> drawingAreaBookmarks = new ArrayList<DrawingAreaBookmark>();
    private Set<HisScene.SceneObserver> sceneObservers = new HashSet<HisScene.SceneObserver>();

    public His3DScene(HisClientRenderer renderer) {
        this.renderer = renderer;
        this.canvas3D = renderer.getHis3dCanvasForScene(this);
        FrameRect fr = FrameRect.withWidthAndHeight(4.0f, 3.0f);
        this.drawingAreaBookmarks.add(new DrawingAreaBookmark(new Vector3f(10.0f, 0.0f, 0.0f), MathUtils.createQuaternionWithEulerAnglesDeg(0.0f, -90.0f, 90.0f), fr));
        this.drawingAreaBookmarks.add(new DrawingAreaBookmark(new Vector3f(5.0f, 0.0f, 0.0f), MathUtils.createQuaternionWithEulerAnglesDeg(0.0f, -90.0f, 90.0f), fr));
        this.drawingAreaBookmarks.add(new DrawingAreaBookmark(new Vector3f(0.0f, 0.0f, 0.0f), MathUtils.createQuaternionWithEulerAnglesDeg(0.0f, -90.0f, 90.0f), fr));
        this.drawingAreaBookmarks.add(new DrawingAreaBookmark());
    }

    public His3DCanvas get3dCanvas() {
        return this.canvas3D;
    }

    @Override
    public Set<His3DCanvas> getAllCanvases() {
        HashSet<His3DCanvas> c = new HashSet<His3DCanvas>(this.canvasesOfDrawingAreas.values());
        c.addAll(this.canvasesWithoutDrawingAreas);
        c.add(this.canvas3D);
        return c;
    }

    public His3DCanvas get3dCanvasForDrawingArea(DrawingArea drawingArea) {
        His3DCanvas canvas = this.renderer.getNewEmptyHis3dCanvas();
        canvas.addStrokeObserver(this);
        this.canvasesOfDrawingAreas.put(drawingArea, canvas);
        return canvas;
    }

    @Override
    public His3DCanvas createNewEmpty3dCanvas() {
        His3DCanvas canvas = this.renderer.getNewEmptyHis3dCanvas();
        this.canvasesWithoutDrawingAreas.add(canvas);
        canvas.addStrokeObserver(this);
        return canvas;
    }

    public void clearAllCanvas3Ds() {
        this.canvas3D.clear();
        for (His3DCanvas c3d : this.canvasesOfDrawingAreas.values()) {
            c3d.clear();
        }
        for (His3DCanvas c3d : this.canvasesWithoutDrawingAreas) {
            c3d.clear();
        }
    }

    public DrawingAreaBookmark getDrawingAreaBookmark(int bookMarkIndex) {
        if (0 <= bookMarkIndex && bookMarkIndex < this.drawingAreaBookmarks.size()) {
            return this.drawingAreaBookmarks.get(bookMarkIndex);
        }
        return null;
    }

    @Override
    public void addStroke(Stroke3D stroke) {
        this.canvas3D.addStroke(stroke);
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeAdded(this, stroke);
        }
    }

    public void addStrokeAndPaintCompletely(Stroke3D stroke) {
        this.canvas3D.addStrokeAndPaintCompletely(stroke);
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeAdded(this, stroke);
        }
    }

    @Override
    public void addStrokePoint(UUID id, Stroke3DPoint point, Set<HisScene.SceneObserver> informedSceneObserver) {
        Stroke3D s = this.canvas3D.getStroke(id);
        if (s != null) {
            s.addPoint(point);
        }
    }

    @Override
    public void setStrokeStrokeAnchorPoint(UUID strokeId, Vector3f vector) {
        for (His3DCanvas c : this.getAllCanvases()) {
            Stroke3D s = c.getStroke(strokeId);
            if (s == null) continue;
            s.setPosition(vector);
        }
    }

    @Override
    public void eraseStroke(UUID strokeId, Set<HisScene.SceneObserver> informed) {
        for (His3DCanvas c : this.getAllCanvases()) {
            Stroke3D s = c.getStroke(strokeId);
            if (s == null) continue;
            c.eraseStroke(s);
        }
    }

    @Override
    public void setStrokeVisibility(UUID strokeId, Boolean visibility, Set<HisScene.SceneObserver> informed) {
        Stroke3D s = this.canvas3D.getStroke(strokeId);
        this.canvas3D.setVisibilityForStrokeWithoutNotifying(s, visibility);
    }

    @Override
    public void adaptTo(HisScene leadingScene) {
        this.clearAllCanvas3Ds();
        for (Stroke3D s : leadingScene.getAllStrokes()) {
            this.canvas3D.addStroke(s);
        }
    }

    @Override
    public void addSceneObserver(HisScene.SceneObserver l) {
        this.sceneObservers.add(l);
        l.onStartedObservation(this);
    }

    @Override
    public void removeSceneObserver(HisScene.SceneObserver l) {
        this.sceneObservers.remove(l);
        l.onStoppedObservation(this);
    }

    @Override
    public Collection<Stroke3D> getAllStrokes() {
        HashSet<Stroke3D> c = new HashSet<Stroke3D>();
        for (His3DCanvas canvas : this.getAllCanvases()) {
            c.addAll(canvas.getAllVisibleStrokes());
        }
        return c;
    }

    @Override
    public void onStrokeWasAddedToCanvas(His3DCanvas canvas, Stroke3D stroke) {
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeAdded(this, stroke);
        }
    }

    @Override
    public void onStrokeWasFinished(UUID id) {
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeFinished(this, id);
        }
    }

    @Override
    public void onStrokeWasMoved(UUID uuid, Vector3f newAnchor) {
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeMoved(this, uuid, newAnchor);
        }
    }

    @Override
    public void onStrokeWasErased(UUID uuid) {
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeErased(this, uuid);
        }
    }

    @Override
    public void onStrokeVisibilityChanged(UUID uuid, boolean isVisible) {
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeVisibilityChanged(this, uuid, isVisible);
        }
    }

    @Override
    public HisSceneMemento getMemento() {
        HisSceneMemento m = new HisSceneMemento();
        try {
            His3dSceneXMLDocument doc = new His3dSceneXMLDocument();
            doc.saveSceneIntoDocument(this);
            ByteArrayOutputStream bos = doc.getAsStream();
            byte[] compressedXml = CompressionUtils.compress(bos.toByteArray());
            m.compressedBytesOfHis3dSceneXMLDocument = compressedXml;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return m;
    }

    @Override
    public void adaptTo(HisSceneMemento sceneMemento) {
        if (sceneMemento.compressedBytesOfHis3dSceneXMLDocument != null) {
            byte[] data = sceneMemento.compressedBytesOfHis3dSceneXMLDocument;
            try {
                byte[] xmlBytes = CompressionUtils.decompress(data);
                His3dSceneXMLDocument doc = new His3dSceneXMLDocument(xmlBytes);
                doc.loadDocumentIntoScene(this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DataFormatException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        } else {
            throw new NullPointerException("HisSceneMemento contained nothing");
        }
    }

    @Override
    public void onStrokePointWasAdded(UUID id, Stroke3DPoint point) {
        HashSet<HisScene.SceneObserver> informed = new HashSet<HisScene.SceneObserver>(this.sceneObservers);
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokePointAdded(this, id, point, informed);
        }
    }

    @Override
    public void setStaticSceneElementState(StaticSceneElementState state) {
        StaticSceneElementState currentstate = this.renderer.getStaticSceneElementState(state.element);
        if (!state.equals(currentstate)) {
            this.renderer.setStaticSceneElementState(state);
            for (HisScene.SceneObserver o : this.sceneObservers) {
                o.onStaticSceneElementStateHasChanged(this, state);
            }
        }
    }

    @Override
    public StaticSceneElementState getStaticSceneElementState(StaticSceneElementState.Element e) {
        return this.renderer.getStaticSceneElementState(e);
    }

    public Stroke3DSelectionAndTransformationGroup createStrokeTransformationGroup() {
        Stroke3DSelectionAndTransformationGroup g = new Stroke3DSelectionAndTransformationGroup();
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onSelectionAndTransformationGroupCreated(this, g);
        }
        return g;
    }

    public void clearTransformationGroup(Stroke3DSelectionAndTransformationGroup g) {
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onSelectionAndTransformationGroupCleared(this, g);
        }
    }
}

