/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.AbstractStroke;
import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.core.Stroke2D;
import com.hybridlab.hyve3d.core.StrokeStatusObserver;
import com.hybridlab.hyve3d.core.commands.StrokeModificationCommand;
import com.hybridlab.hyve3d.network.messages.CommandMessage;
import java.util.ArrayList;
import java.util.List;

public class SatelliteStroke2DManager
implements StrokeStatusObserver {
    private Satellite satellite;
    private List<Stroke2D> managedStrokes = new ArrayList<Stroke2D>();

    public SatelliteStroke2DManager(Satellite sat) {
        this.satellite = sat;
    }

    @Override
    public void onObservedStrokeErased(AbstractStroke erasedStroke) {
        StrokeModificationCommand cmd = new StrokeModificationCommand(erasedStroke.getStrokeId());
        cmd.setModification(StrokeModificationCommand.Modification.ERASE, null);
        this.satellite.sendMessage(new CommandMessage(cmd));
    }

    @Override
    public void onVisibilityOfObservedStrokeChanged(AbstractStroke stroke, boolean isVisible) {
        StrokeModificationCommand cmd = new StrokeModificationCommand(stroke.getStrokeId());
        cmd.setModification(StrokeModificationCommand.Modification.VISIBILITY, isVisible);
        this.satellite.sendMessage(new CommandMessage(cmd));
    }

    public void clear() {
        for (Stroke2D rps2d : this.managedStrokes) {
            rps2d.unRegisterStatusObserver(this);
        }
        this.managedStrokes.clear();
    }

    public void add(List<Stroke2D> strokes) {
        this.managedStrokes.addAll(strokes);
        for (Stroke2D rps2d : this.managedStrokes) {
            rps2d.registerStatusObserver(this);
        }
    }

    public void add(Stroke2D stroke2d) {
        this.managedStrokes.add(stroke2d);
        stroke2d.registerStatusObserver(this);
    }
}

