/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.AbstractStroke;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeStatusObserver;
import com.hybridlab.hyve3d.core.StylusPressure;
import com.jme3.math.Vector2f;
import java.util.ArrayList;
import java.util.List;

public class Stroke2D
extends AbstractStroke
implements StrokeStatusObserver {
    private List<Vector2f> points = new ArrayList<Vector2f>();
    private AbstractStroke observedStroke = null;

    public void addPoints(List<Vector2f> points) {
        this.points.addAll(points);
    }

    public void addPoints(Vector2f[] points) {
        for (Vector2f p : points) {
            this.points.add(p);
        }
    }

    public List<Vector2f> getPoints() {
        return this.points;
    }

    public Vector2f[] getPointsArray() {
        return this.points.toArray(new Vector2f[this.points.size()]);
    }

    @Override
    public void onObservedStrokeErased(AbstractStroke erasedStroke) {
        this.setStatus(AbstractStroke.StrokeStatus.ERASED);
    }

    @Override
    public void onVisibilityOfObservedStrokeChanged(AbstractStroke stroke, boolean isVisible) {
        if (isVisible) {
            this.setStatus(AbstractStroke.StrokeStatus.VISIBLE);
        } else {
            this.setStatus(AbstractStroke.StrokeStatus.INVISIBLE);
        }
    }

    public void cancelStatusObservation() {
        if (this.observedStroke != null) {
            this.observedStroke.unRegisterStatusObserver(this);
        }
    }

    public void observeStatusOf(AbstractStroke observedStroke3D) {
        observedStroke3D.registerStatusObserver(this);
        this.observedStroke = observedStroke3D;
    }

    public static Stroke2D createSimilarButDifferentPoints(Stroke2D o, List<Vector2f> differentpoints, List<StylusPressure> differentpressures) {
        Stroke2D s = new Stroke2D();
        s.ink = o.ink.clone();
        s.points = differentpoints;
        s.pressures = differentpressures;
        s.id = StrokeId.random();
        return s;
    }
}

