/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DDataObserver;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.hybridlab.hyve3d.geometry.Line;
import com.hybridlab.hyve3d.geometry.StrokePipeMesh;
import com.hybridlab.hyve3d.geometry.StrokeRectangleTubeMesh;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.shape.Sphere;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class Stroke3DJmeVisualization
implements Stroke3DDataObserver {
    List<Vector3f> points = new ArrayList<Vector3f>();
    Line strokeLine;
    Node rootNode = new Node("Stroke " + this.hashCode());
    Node rotationPivotNode = new Node("rotationPivotNode " + this.hashCode());
    Node rotationBackPivotNode = new Node("rotationBackPivotNode " + this.hashCode());
    AssetManager assetManager;
    float thickness = 1.0f;
    float thicknessVisualizationFactor = 1.0f;
    ColorRGBA color = ColorRGBA.Yellow;
    ColorRGBA selectedcolor = ColorRGBA.Magenta;
    Material mat;
    private StrokePipeMesh strokeMesh;
    private StrokeRectangleTubeMesh strokeRectangleTubeMesh;
    private StrokeInk.StrokeStyle style = StrokeInk.StrokeStyle.TriangleStrokeTube;
    private Geometry strokeLineGeometry;
    private Jme3HisClientRenderer renderer;
    private Stroke3D stroke;
    private boolean debug = false;
    private boolean paintedFirstTime = false;
    private int lastAddedPointIndex = -1;

    public Node getRootNode() {
        return this.rootNode;
    }

    public Stroke3DJmeVisualization(AssetManager assetManager, Stroke3D s3d, Jme3HisClientRenderer jmeRenderer) {
        this.renderer = jmeRenderer;
        this.stroke = s3d;
        this.assetManager = assetManager;
        this.thickness = s3d.getInk().getThickness();
        this.color = s3d.getInk().getColor();
        this.mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat.setColor("Color", this.color);
        this.rootNode.attachChild((Spatial)this.rotationPivotNode);
        this.rotationPivotNode.attachChild((Spatial)this.rotationBackPivotNode);
        if (this.debug) {
            float size1 = 0.2f;
            float size2 = 0.5f;
            float size3 = 1.0f;
            this.rootNode.attachChild((Spatial)this.createCoordinateAxes(Vector3f.ZERO, new Vector3f(size1, size1, size1), ColorRGBA.Red));
            this.rotationPivotNode.attachChild((Spatial)this.createCoordinateAxes(Vector3f.ZERO, new Vector3f(size2, size2, size2), ColorRGBA.Green));
            this.rotationBackPivotNode.attachChild((Spatial)this.createCoordinateAxes(Vector3f.ZERO, new Vector3f(size3, size3, size3), ColorRGBA.Blue));
        }
        this.strokeLine = new Line(Mesh.Mode.LineStrip, this.points.toArray(new Vector3f[1]));
        this.strokeLine.setLineWidth(this.thickness * this.thicknessVisualizationFactor);
        this.strokeLineGeometry = new Geometry("Stroke", (Mesh)this.strokeLine);
        this.strokeLineGeometry.setMaterial(this.mat);
        this.strokeMesh = new StrokePipeMesh(assetManager, s3d.getInk());
        this.strokeRectangleTubeMesh = new StrokeRectangleTubeMesh(assetManager, s3d.getInk());
        this.style = s3d.getInk().getStyle();
        this.showOrHideStrokeVisualizationsDependingOnCurrentStyle();
        s3d.registerDataObserver(this);
        this.paintKnownPoints();
    }

    protected Geometry putShape(Mesh shape, ColorRGBA color) {
        Geometry g = new Geometry("coordinate axis", shape);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        return g;
    }

    protected Node createCoordinateAxes(Vector3f pos, Vector3f sizeEachDimension, ColorRGBA dotcolor) {
        Node node = new Node("axes");
        Arrow arrow = new Arrow(new Vector3f(sizeEachDimension.x, 0.0f, 0.0f));
        arrow.setLineWidth(2.0f);
        Geometry g = this.putShape((Mesh)arrow, ColorRGBA.Red);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, sizeEachDimension.y, 0.0f));
        arrow.setLineWidth(2.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Green);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, 0.0f, sizeEachDimension.z));
        arrow.setLineWidth(2.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Blue);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        Sphere dot = new Sphere(16, 16, 0.05f);
        g = this.putShape((Mesh)dot, dotcolor);
        node.attachChild((Spatial)g);
        return node;
    }

    public void paintFirstTimeOrDoNothing() {
        if (!this.paintedFirstTime) {
            this.paintedFirstTime = true;
            this.paintKnownPoints();
        }
    }

    private void paintKnownPoints() {
        ArrayList<Stroke3DPoint> strokepoints = new ArrayList<Stroke3DPoint>(this.stroke.getPointsInSceneCoordinates());
        for (int i = 0; i < strokepoints.size(); ++i) {
            Stroke3DPoint sp = (Stroke3DPoint)strokepoints.get(i);
            try {
                this.addPoint(i, sp);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    private void addPoint(int pointindex, Stroke3DPoint sp) {
        if (pointindex < this.lastAddedPointIndex) {
            Logger.getAnonymousLogger().severe(String.format("Added Point with lower index then expected: pointindex=%d lastAddedPointIndex=%d.", pointindex, this.lastAddedPointIndex));
        } else {
            this.lastAddedPointIndex = pointindex;
            Vector3f pos = sp.position;
            float normalizedPressure = sp.pressure.getNormalizedValue();
            this.points.add(pos);
            this.strokeLine.feed(this.points.toArray(new Vector3f[this.points.size()]));
            this.strokeMesh.addStrokePoint(pos, normalizedPressure);
            this.strokeRectangleTubeMesh.addStrokePoint(pointindex, sp);
            this.rootNode.updateGeometricState();
            this.rootNode.updateModelBound();
        }
    }

    private void showOrHideStrokeVisualizationsDependingOnCurrentStyle() {
        switch (this.style) {
            case Line: {
                this.rotationBackPivotNode.detachChild((Spatial)this.strokeMesh);
                this.rotationBackPivotNode.attachChild((Spatial)this.strokeLineGeometry);
                this.rotationBackPivotNode.detachChild((Spatial)this.strokeRectangleTubeMesh);
                break;
            }
            case TriangleStrokeTube: {
                this.rotationBackPivotNode.attachChild((Spatial)this.strokeMesh);
                this.rotationBackPivotNode.detachChild((Spatial)this.strokeLineGeometry);
                this.rotationBackPivotNode.detachChild((Spatial)this.strokeRectangleTubeMesh);
                break;
            }
            case RectangleStrokeTube: {
                this.rotationBackPivotNode.attachChild((Spatial)this.strokeRectangleTubeMesh);
                this.rotationBackPivotNode.detachChild((Spatial)this.strokeMesh);
                this.rotationBackPivotNode.detachChild((Spatial)this.strokeLineGeometry);
                break;
            }
        }
    }

    public void setStyle(StrokeInk.StrokeStyle newStyle) {
        if (!this.style.equals((Object)newStyle)) {
            this.style = newStyle;
            this.showOrHideStrokeVisualizationsDependingOnCurrentStyle();
        }
    }

    public Spatial getStrokeRootNode() {
        return this.rootNode;
    }

    @Override
    public void onLastPointWasAdded(Stroke3D stroke) {
    }

    @Override
    public void onPointAdded(final Stroke3D stroke, final int pointIndex) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                Stroke3DPoint p = stroke.getStrokePoint(pointIndex);
                Stroke3DJmeVisualization.this.addPoint(pointIndex, p);
                return this;
            }
        };
        if (!this.renderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.renderer.enqueue(c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onSelectedStateChanged(final Stroke3D stroke) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                boolean isSelected = stroke.isSelected();
                ColorRGBA c = Stroke3DJmeVisualization.this.color;
                c = isSelected ? Stroke3DJmeVisualization.this.selectedcolor : Stroke3DJmeVisualization.this.color;
                Stroke3DJmeVisualization.this.mat.setColor("Color", c);
                Stroke3DJmeVisualization.this.strokeRectangleTubeMesh.setColor(c);
                Stroke3DJmeVisualization.this.strokeMesh.setColor(c);
                return this;
            }
        };
        if (!this.renderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.renderer.enqueue(c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onPositionChanged(final Stroke3D stroke) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                Vector3f p = stroke.getPosition();
                Stroke3DJmeVisualization.this.rootNode.setLocalTranslation(p);
                return this;
            }
        };
        if (!this.renderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.renderer.enqueue(c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onRotationChanged(Stroke3D stroke3d) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                Quaternion r = Stroke3DJmeVisualization.this.stroke.getRotation();
                Stroke3DJmeVisualization.this.rotationPivotNode.setLocalRotation(r);
                return this;
            }
        };
        if (!this.renderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.renderer.enqueue(c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onPivotChanged(Stroke3D stroke3d) {
        final Vector3f p = this.stroke.getPivotInStrokeSpace();
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                System.out.println(String.format(this.getClass().getSimpleName() + ".onPivotChanged p=%s ", p));
                Stroke3DJmeVisualization.this.rotationPivotNode.setLocalTranslation(p);
                Stroke3DJmeVisualization.this.rotationBackPivotNode.setLocalTranslation(p.negate());
                return this;
            }
        };
        if (!this.renderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            System.out.println(String.format("enqueuing ... " + this.getClass().getSimpleName() + ".onPivotChanged p=%s ", p));
            this.renderer.enqueue(c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

