/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.network.transport.fab8.FAB8_MessageTranslator;
import com.jme3.network.serializing.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;

@Serializable
public class StrokeId {
    private transient UUID uuid = null;

    public StrokeId(UUID uuid) {
        this.uuid = uuid;
    }

    public StrokeId duplicate() {
        StrokeId d = StrokeId.fromUUIDBytes(this.getUuidBytes());
        return d;
    }

    public StrokeId() {
        this.uuid = UUID.randomUUID();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String toString() {
        return super.toString() + " [" + this.uuid.toString() + "]";
    }

    public static StrokeId fromUUIDBytes(byte[] uuidbytes) {
        if (null == uuidbytes || uuidbytes.length != 16) {
            throw new IllegalArgumentException();
        }
        ByteBuffer bb = ByteBuffer.wrap(uuidbytes);
        long first = bb.getLong();
        long second = bb.getLong();
        return new StrokeId(new UUID(first, second));
    }

    public String getUuidString() {
        return this.uuid.toString();
    }

    public void setUuidBytes(String uuidString) {
        this.uuid = UUID.fromString(uuidString);
    }

    public byte[] getUuidBytes() {
        ByteBuffer bb = ByteBuffer.allocate(16).order(FAB8_MessageTranslator.BYTE_ORDER_SENDING);
        bb.putLong(this.uuid.getMostSignificantBits());
        bb.putLong(this.uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static StrokeId random() {
        return new StrokeId(UUID.randomUUID());
    }
}

