/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@com.jme3.network.serializing.Serializable
public class StylusPressure
implements Serializable {
    private static final long serialVersionUID = -7652130915901844912L;
    public static short maxpressure = Short.MAX_VALUE;
    public static final StylusPressure NoPressure = new StylusPressure();
    private short value = (short)-1;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StylusPressure other = (StylusPressure)obj;
        return this.value == other.value;
    }

    public String toString() {
        String v = "";
        v = this.value == -1 ? "NoPressure" : (this.value == maxpressure ? "MaximumPressure" : String.valueOf(this.getNormalizedValue()));
        return "StylusPressure [value=" + v + "]";
    }

    public StylusPressure(short s) {
        this.value = s;
    }

    public StylusPressure() {
    }

    public StylusPressure(float normalizedPressure) {
        this.value = (short)(normalizedPressure * (float)maxpressure);
    }

    public float getNormalizedValue() {
        if (this.value == -1) {
            return 0.0f;
        }
        return (float)this.value / 32767.0f;
    }

    public static List<StylusPressure> createPressures(short[] pressures) {
        ArrayList<StylusPressure> plist = new ArrayList<StylusPressure>();
        for (short p : pressures) {
            plist.add(new StylusPressure(p));
        }
        return plist;
    }

    public static List<StylusPressure> createPressures(List<Float> pressures) {
        ArrayList<StylusPressure> ps = new ArrayList<StylusPressure>(pressures.size());
        for (Float normalizedPressure : pressures) {
            ps.add(new StylusPressure(normalizedPressure.floatValue()));
        }
        return ps;
    }
}

