/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.animation;

import com.hybridlab.hyve3d.hyve.QueuedRunner;
import com.hybridlab.utils.Interpolation;

public class AnimatedValueSetter
implements Runnable {
    private boolean isWorking = false;
    private float goal = 0.0f;
    private float current = 0.0f;
    private long lastRun;
    private float oneCycleDurationMillis;
    private SetableValue work;
    private QueuedRunner runner;

    public AnimatedValueSetter(SetableValue work, QueuedRunner runner, int milliSecondsForOneCycle) {
        this.work = work;
        this.runner = runner;
        this.oneCycleDurationMillis = milliSecondsForOneCycle;
    }

    @Override
    public void run() {
        if (!this.hasWorkTodo() || this.work == null) {
            return;
        }
        if (this.isWorking) {
            long sinceLastRun = System.currentTimeMillis() - this.lastRun;
            float step = (float)sinceLastRun / this.oneCycleDurationMillis;
            this.doStep(step);
            if (this.hasWorkTodo()) {
                this.scheduleNextRun();
            } else {
                this.finish();
            }
        } else {
            this.isWorking = true;
            this.lastRun = System.currentTimeMillis();
            this.scheduleNextRun();
        }
    }

    private void doStep(float step) {
        float nextCurrent;
        float diff = this.goal - this.current;
        if (diff > 0.0f) {
            nextCurrent = this.current + step;
            if (nextCurrent > this.goal) {
                nextCurrent = this.goal;
            }
        } else {
            nextCurrent = this.current - step;
            if (nextCurrent < this.goal) {
                nextCurrent = this.goal;
            }
        }
        this.current = nextCurrent;
        float value = Interpolation.inttrf(this.current, 0.0f, 1.0f, this.work.getMin(), this.work.getMax());
        this.work.setValue(value);
    }

    private void scheduleNextRun() {
        this.runner.addTodo(this);
    }

    private void finish() {
        this.isWorking = false;
    }

    public void animateToMin() {
        this.goal = 0.0f;
        if (this.hasWorkTodo() && !this.isWorking()) {
            this.startWork();
        }
    }

    public void animateToMax() {
        this.goal = 1.0f;
        if (this.hasWorkTodo() && !this.isWorking()) {
            this.startWork();
        }
    }

    public void goToMax(boolean b) {
        if (b) {
            this.animateToMax();
        } else {
            this.animateToMin();
        }
    }

    private void startWork() {
        this.runner.addTodo(this);
    }

    private boolean hasWorkTodo() {
        return this.goal != this.current;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public static interface SetableValue {
        public float getMin();

        public float getMax();

        public void setValue(float var1);
    }
}

