/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.animation;

import com.hybridlab.hyve3d.core.animation.PositionAndRotationChangeAble;
import com.hybridlab.hyve3d.core.animation.SimpleAnimation;
import com.hybridlab.utils.Interpolation;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public class InfiniteTranslationAnimation
implements SimpleAnimation {
    PositionAndRotationChangeAble animative;
    private Vector3f translationPerSecond = Vector3f.ZERO;
    float currentAnimationTime = 0.0f;
    float duration = 1.0f;
    float introductionDurationInSeconds = 0.0f;
    private boolean started = false;
    private boolean finished = false;
    private boolean running = false;

    public InfiniteTranslationAnimation(PositionAndRotationChangeAble animative) {
        this.animative = animative;
    }

    @Override
    public void update(float tpf) {
        if (this.running && !this.finished) {
            this.currentAnimationTime += tpf;
            Vector3f targetTranslation = this.calculateTargetPosition(tpf);
            this.animative.setPosition(targetTranslation);
        }
    }

    Vector3f calculateTargetPosition(float tpf) {
        Vector3f currentTranslation = this.animative.getPosition();
        Vector3f step = this.calculateStep(tpf);
        Vector3f targetTranslation = currentTranslation.add(step);
        return targetTranslation;
    }

    public void resume() {
        if (!this.started) {
            this.start();
        }
        this.running = true;
    }

    @Override
    public void start() {
        this.reset();
        this.started = true;
        this.running = true;
    }

    void reset() {
        this.currentAnimationTime = 0.0f;
        this.started = false;
        this.finished = false;
    }

    private Vector3f calculateStep(float tpf) {
        float introductionFactor = 1.0f;
        if (this.currentAnimationTime < this.introductionDurationInSeconds) {
            introductionFactor = Interpolation.inttrf(this.currentAnimationTime, 0.0f, this.introductionDurationInSeconds, 0.0f, 1.0f);
            introductionFactor = Interpolation.slowInFastOut_smoothTrigonometrical(introductionFactor, 2);
        }
        Vector3f step = this.translationPerSecond.mult(tpf).mult(introductionFactor);
        return step;
    }

    public void setTranslationPerSecond(Vector3f translation) {
        this.translationPerSecond = translation;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    public void setIntroDurationInSeconds(float duration) {
        this.introductionDurationInSeconds = duration;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public Quaternion getStartRotation() {
        return this.animative.getRotation();
    }

    public Quaternion getCurrentRotation() {
        return this.animative.getRotation();
    }
}

