/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.animation;

import com.hybridlab.hyve3d.core.animation.PositionAndRotationChangeAble;
import com.hybridlab.hyve3d.core.animation.SimpleAnimation;
import com.hybridlab.hyve3d.network.messages.OrbitMessage;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public class OrbitingController
implements SimpleAnimation {
    private OrbitMessage latestMessage;
    private boolean needsUpdate = false;
    private boolean running = false;
    private boolean finished = false;
    private PositionAndRotationChangeAble orbiter;
    private Vector3f initialTargetPosition;
    private Vector3f initialOrbiterPosition;
    private Quaternion initialOrbiterRotation;
    private Vector3f orbitPlaneNormal;
    private Vector3f initialTargetToOrbiterVector;
    private Vector3f heightVector;
    private Vector3f initialTargetToProjectedOrbiterPositionInPlane;

    public OrbitingController(Vector3f target, PositionAndRotationChangeAble orbiter, Vector3f orbitPlaneNormal) {
        this.initialTargetPosition = target;
        this.orbiter = orbiter;
        this.initialOrbiterPosition = this.orbiter.getPosition();
        this.initialOrbiterRotation = this.orbiter.getRotation();
        this.initialTargetToOrbiterVector = this.initialOrbiterPosition.subtract(this.initialTargetPosition);
        this.orbitPlaneNormal = orbitPlaneNormal.normalize();
        this.heightVector = this.orbitPlaneNormal.project(this.initialTargetToOrbiterVector);
        this.initialTargetToProjectedOrbiterPositionInPlane = this.initialOrbiterPosition.subtract(this.heightVector).subtract(target);
    }

    @Override
    public void update(float tpf) {
        if (this.running && this.needsUpdate) {
            this.performupdate();
        }
    }

    private void performupdate() {
        Quaternion r = new Quaternion();
        r = r.fromAngleAxis(this.latestMessage.getAngleRad(), this.orbitPlaneNormal);
        Vector3f rotatedInPlane = r.mult(this.initialTargetToProjectedOrbiterPositionInPlane);
        Vector3f orbiterPosition = this.initialTargetPosition.add(rotatedInPlane).add(this.heightVector);
        Quaternion newOrbiterRotation = r.mult(this.initialOrbiterRotation);
        this.orbiter.setPosition(orbiterPosition);
        this.orbiter.setRotation(newOrbiterRotation);
        this.needsUpdate = false;
    }

    @Override
    public void start() {
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void feed(OrbitMessage orbitMsg) {
        if (orbitMsg.hasDifferentValuesComparedTo(this.latestMessage)) {
            this.latestMessage = orbitMsg;
            this.needsUpdate = true;
        }
    }
}

