/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.animation;

import com.hybridlab.hyve3d.core.animation.PositionAndRotationChangeAble;
import com.hybridlab.hyve3d.core.animation.SimpleAnimation;
import com.hybridlab.utils.Interpolation;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

@Deprecated
public class SimplePositionAndRotationAnimation
implements SimpleAnimation {
    private PositionAndRotationChangeAble animative;
    private Vector3f targetTranslation = Vector3f.ZERO;
    private Vector3f startTranslation = Vector3f.ZERO;
    private Quaternion startRotation;
    private Quaternion targetRotation;
    private List<Callable<Object>> stepCallables = new ArrayList<Callable<Object>>();
    private float currentAnimationTime = 0.0f;
    private float duration = 1.0f;
    private boolean started = false;
    private boolean running = false;
    private boolean finished = false;
    public String name = "";

    public SimplePositionAndRotationAnimation(PositionAndRotationChangeAble animative, float duration) {
        this.animative = animative;
        if (duration < 0.0f) {
            throw new IllegalArgumentException("duration must not be less than zero");
        }
        this.duration = duration;
        this.setStartAndEndRotation(animative.getRotation(), animative.getRotation());
    }

    @Override
    public void update(float tpf) {
        if (this.running && !this.finished) {
            float f;
            this.currentAnimationTime += tpf;
            if (this.currentAnimationTime > this.duration) {
                f = 1.0f;
                this.finished = true;
            } else {
                f = Interpolation.inttrf(this.currentAnimationTime, 0.0f, this.duration, 0.0f, 1.0f);
            }
            float t = Interpolation.fastInSlowOut_smoothTrigonometrical(f, 2);
            if (!this.startTranslation.equals((Object)this.targetTranslation)) {
                Vector3f currentTranslation = this.interpolate(t, this.startTranslation, this.targetTranslation);
                this.animative.setPosition(currentTranslation);
            }
            if (!this.startRotation.equals((Object)this.targetRotation)) {
                Quaternion currentRotation = this.startRotation.clone();
                currentRotation.slerp(this.targetRotation, t);
                this.animative.setRotation(currentRotation);
            }
            for (Callable<Object> c : this.stepCallables) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void start() {
        this.reset();
        this.started = true;
        this.running = true;
    }

    private void reset() {
        this.currentAnimationTime = 0.0f;
        this.started = false;
        this.finished = false;
    }

    private Vector3f interpolate(float f, Vector3f a, Vector3f b) {
        return new Vector3f(FastMath.interpolateLinear((float)f, (float)a.x, (float)b.x), FastMath.interpolateLinear((float)f, (float)a.y, (float)b.y), FastMath.interpolateLinear((float)f, (float)a.z, (float)b.z));
    }

    public void setStartAndEndPosition(Vector3f start, Vector3f target) {
        this.startTranslation = start;
        this.targetTranslation = target;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    public void setStartPosition(Vector3f v) {
        this.startTranslation = v;
    }

    public void setEndPosition(Vector3f v) {
        this.targetTranslation = v;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void setStartAndEndRotation(Quaternion startRotation, Quaternion endRotation) {
        this.startRotation = startRotation;
        this.targetRotation = endRotation;
    }

    public void addStepCallable(Callable<Object> c) {
        this.stepCallables.add(c);
    }
}

