/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.commands;

import com.hybridlab.hyve3d.core.commands.Command;
import com.hybridlab.hyve3d.core.commands.CommandFactory;
import com.hybridlab.utils.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class CommandChangeMode
extends Command {
    private static final Logger logger = Logger.getLogger(CommandChangeMode.class.getSimpleName());
    private String modeStr = null;
    private SatelliteMode mode = null;

    public CommandChangeMode() {
        this.commandName = CommandFactory.CommandNames.changeMode;
    }

    public CommandChangeMode(Map<String, Object> parameter) {
        if (null != parameter) {
            this.setModeString((String)parameter.get("mode"));
        } else {
            logger.warning("No Parameter for ChangeMode-Command");
        }
        this.commandName = CommandFactory.CommandNames.changeMode;
    }

    public CommandChangeMode(SatelliteMode modeToChangeTo) {
        this.setModeString(modeToChangeTo.toString());
        this.commandName = CommandFactory.CommandNames.changeMode;
    }

    public String getModeString() {
        if (this.mode == null) {
            return this.modeStr;
        }
        return this.getMode().toString();
    }

    public SatelliteMode getMode() {
        if (null == this.mode) {
            return SatelliteMode.Unkown;
        }
        return this.mode;
    }

    public void setMode(SatelliteMode mode) {
        this.mode = mode;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mode", this.getModeString());
        JSONObject j = new JSONObject();
        j.put("cmd", (Object)this.commandName.toString());
        j.put("params", JsonHelper.toJSON(params));
        return j;
    }

    public void setModeString(String modeStr) {
        this.modeStr = modeStr;
        try {
            if (null != this.modeStr && !this.modeStr.isEmpty()) {
                this.setMode(SatelliteMode.valueOf(this.modeStr));
            }
        }
        catch (IllegalArgumentException iae) {
            logger.warning("Unkown Mode");
            this.mode = null;
        }
    }

    public static enum SatelliteMode {
        Unkown,
        NotConnectedToDrawingArea,
        Default,
        Navigation,
        Drawing,
        DrawingAreaTransformation,
        DrawingAreaTransformationWhileSelection,
        Editing,
        SelectionTransformation,
        IpadCalibration;

    }
}

