/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.commands;

import com.hybridlab.hyve3d.core.commands.Command;
import com.hybridlab.hyve3d.core.commands.CommandFactory;
import com.hybridlab.utils.JsonHelper;
import com.jme3.network.serializing.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

@Serializable
public class JoinSessionOnHostCommand
extends Command {
    private Map<String, Object> params;

    public JoinSessionOnHostCommand() {
        this.commandName = CommandFactory.CommandNames.joinSessionOnHost;
        this.params = new HashMap<String, Object>();
    }

    public JoinSessionOnHostCommand(UUID sessionid, String host, int port) {
        this();
        this.params.put("sessionid", sessionid.toString());
        this.params.put("port", port);
        this.params.put("host", host);
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject j = new JSONObject();
        j.put("cmd", (Object)this.commandName.toString());
        j.put("params", JsonHelper.toJSON(this.params));
        return j;
    }

    public UUID getSessionId() {
        try {
            return UUID.fromString((String)this.params.get("sessionid"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getHost() {
        try {
            return (String)this.params.get("host");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer getPort() {
        try {
            return (Integer)this.params.get("port");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

